/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextRange {
    private final int myStartOffset;
    private final int myEndOffset;

    public TextRange(int startOffset, int endOffset) {
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
    }

    public final int getStartOffset() {
        return this.myStartOffset;
    }

    public final int getEndOffset() {
        return this.myEndOffset;
    }

    public final int getLength() {
        return this.myEndOffset - this.myStartOffset;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextRange)) {
            return false;
        }
        TextRange range = (TextRange)obj;
        return this.myStartOffset == range.myStartOffset && this.myEndOffset == range.myEndOffset;
    }

    public int hashCode() {
        return this.myStartOffset + this.myEndOffset;
    }

    public boolean contains(TextRange range) {
        return this.myStartOffset <= range.getStartOffset() && this.myEndOffset >= range.getEndOffset();
    }

    public String toString() {
        return "(" + this.myStartOffset + "," + this.myEndOffset + ")";
    }

    public boolean contains(int offset) {
        return this.myStartOffset <= offset && offset < this.myEndOffset;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String substring(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/TextRange.substring must not be null");
        }
        String string = str.substring(this.myStartOffset, this.myEndOffset);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/TextRange.substring must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public TextRange cutOut(@NotNull TextRange subRange) {
        if (subRange == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/TextRange.cutOut must not be null");
        }
        assert (subRange.getStartOffset() <= this.getLength()) : subRange + "; this=" + this;
        assert (subRange.getEndOffset() <= this.getLength()) : subRange + "; this=" + this;
        TextRange textRange = new TextRange(this.myStartOffset + subRange.getStartOffset(), Math.min(this.myEndOffset, this.myStartOffset + subRange.getEndOffset()));
        if (textRange == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/TextRange.cutOut must not return null");
        }
        return textRange;
    }

    @NotNull
    public TextRange shiftRight(int offset) {
        TextRange textRange;
        if (!(offset == 0 ? (textRange = this) != null : (textRange = new TextRange(this.myStartOffset + offset, this.myEndOffset + offset)) != null)) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/TextRange.shiftRight must not return null");
        }
        return textRange;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public TextRange grown(int lengthDelta) {
        TextRange textRange = TextRange.from(this.myStartOffset, this.getLength() + lengthDelta);
        if (textRange == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/TextRange.grown must not return null");
        }
        return textRange;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static TextRange from(int offset, int length) {
        TextRange textRange = new TextRange(offset, offset + length);
        if (textRange == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/TextRange.from must not return null");
        }
        return textRange;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String replace(@NotNull String original, @NotNull String replacement) {
        if (original == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/TextRange.replace must not be null");
        }
        if (replacement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/TextRange.replace must not be null");
        }
        String beginning = original.substring(0, this.getStartOffset());
        String ending = original.substring(this.getEndOffset(), original.length());
        String string = beginning + replacement + ending;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/TextRange.replace must not return null");
        }
        return string;
    }

    public boolean intersects(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/TextRange.intersects must not be null");
        }
        return Math.max(this.myStartOffset, textRange.getStartOffset()) <= Math.min(this.myEndOffset, textRange.getEndOffset());
    }

    public boolean intersectsStrict(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/TextRange.intersectsStrict must not be null");
        }
        return Math.max(this.myStartOffset, textRange.getStartOffset()) < Math.min(this.myEndOffset, textRange.getEndOffset());
    }

    @Nullable
    public TextRange intersection(@NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/TextRange.intersection must not be null");
        }
        if (!this.intersects(range)) {
            return null;
        }
        return new TextRange(Math.max(this.myStartOffset, range.getStartOffset()), Math.min(this.myEndOffset, range.getEndOffset()));
    }

    public boolean isEmpty() {
        return this.myStartOffset >= this.myEndOffset;
    }

    public TextRange union(TextRange textRange) {
        return new TextRange(Math.min(this.myStartOffset, textRange.getStartOffset()), Math.max(this.myEndOffset, textRange.getEndOffset()));
    }
}

