/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;

public class ShutDownTracker
implements Runnable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.ShutDownTracker");
    private static ShutDownTracker ourInstance;
    private List<Thread> myThreads = new ArrayList<Thread>();
    private List<Thread> myShutdownTreads = new ArrayList<Thread>();

    private ShutDownTracker() {
        Runtime.getRuntime().addShutdownHook(new Thread((Runnable)this, "Shutdown tracker"));
    }

    public static synchronized ShutDownTracker getInstance() {
        if (ourInstance == null) {
            ourInstance = new ShutDownTracker();
        }
        return ourInstance;
    }

    public void run() {
        Thread thread;
        Thread[] threads = this.getStopperThreads();
        while (threads.length > 0) {
            thread = threads[0];
            if (!thread.isAlive()) {
                if (this.isRegistered(thread)) {
                    LOG.error("Thread '" + thread.getName() + "' did not unregister itself from ShutDownTracker.");
                    this.unregisterStopperThread(thread);
                }
            } else {
                try {
                    thread.join(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            threads = this.getStopperThreads();
        }
        while (this.myShutdownTreads.size() > 0) {
            thread = this.myShutdownTreads.remove(0);
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized boolean isRegistered(Thread thread) {
        return this.myThreads.contains(thread);
    }

    private synchronized Thread[] getStopperThreads() {
        return this.myThreads.toArray(new Thread[this.myThreads.size()]);
    }

    public synchronized void registerStopperThread(Thread thread) {
        this.myThreads.add(thread);
    }

    public synchronized void unregisterStopperThread(Thread thread) {
        this.myThreads.remove(thread);
    }

    public void registerShutdownThread(Thread thread) {
        this.myShutdownTreads.add(thread);
    }

    public void registerShutdownThread(int index, Thread thread) {
        this.myShutdownTreads.add(index, thread);
    }
}

