/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutualMap<Key, Value> {
    private final Map<Key, Value> myKey2Value;
    private final Map<Value, Key> myValue2Key;

    public MutualMap(boolean ordered) {
        if (ordered) {
            this.myKey2Value = new LinkedHashMap<Key, Value>();
            this.myValue2Key = new LinkedHashMap<Value, Key>();
        } else {
            this.myKey2Value = new HashMap<Key, Value>();
            this.myValue2Key = new HashMap<Value, Key>();
        }
    }

    public MutualMap() {
        this(false);
    }

    public void put(Key key, Value value) {
        this.myKey2Value.put(key, value);
        this.myValue2Key.put(value, key);
    }

    public Value getValue(Key key) {
        return this.myKey2Value.get(key);
    }

    public Key getKey(Value value) {
        return this.myValue2Key.get(value);
    }

    public int size() {
        return this.myValue2Key.size();
    }

    public boolean containsKey(Key key) {
        return this.myKey2Value.containsKey(key);
    }

    public void remove(Key key) {
        Value value = this.myKey2Value.get(key);
        this.myKey2Value.remove(key);
        this.myValue2Key.remove(value);
    }

    public Collection<Value> getValues() {
        return this.myKey2Value.values();
    }

    public Collection<Key> getKeys() {
        return this.myKey2Value.keySet();
    }

    public void clear() {
        this.myKey2Value.clear();
        this.myValue2Key.clear();
    }
}

