/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiValuesMap<Key, Value> {
    private final Map<Key, Collection<Value>> myBaseMap;

    public MultiValuesMap() {
        this(false);
    }

    public MultiValuesMap(boolean ordered) {
        this.myBaseMap = ordered ? new LinkedHashMap() : new HashMap();
    }

    public void putAll(Key key, List<Value> values) {
        for (Value value : values) {
            this.put(key, value);
        }
    }

    public void putAll(Key key, Value ... values) {
        for (Value value : values) {
            this.put(key, value);
        }
    }

    public void put(Key key, Value value) {
        if (!this.myBaseMap.containsKey(key)) {
            this.myBaseMap.put(key, new HashSet());
        }
        this.myBaseMap.get(key).add(value);
    }

    @Nullable
    public Collection<Value> get(Key key) {
        return this.myBaseMap.get(key);
    }

    public Set<Key> keySet() {
        return this.myBaseMap.keySet();
    }

    public Collection<Value> values() {
        HashSet<Value> result = new HashSet<Value>();
        for (Collection<Value> values : this.myBaseMap.values()) {
            result.addAll(values);
        }
        return result;
    }

    public void remove(Key key, Value value) {
        if (!this.myBaseMap.containsKey(key)) {
            return;
        }
        Collection<Value> values = this.myBaseMap.get(key);
        values.remove(value);
        if (values.isEmpty()) {
            this.myBaseMap.remove(key);
        }
    }

    public void clear() {
        this.myBaseMap.clear();
    }

    public void removeAll(Key key) {
        this.myBaseMap.remove(key);
    }

    public Set<Map.Entry<Key, Collection<Value>>> entrySet() {
        return this.myBaseMap.entrySet();
    }

    public boolean isEmpty() {
        return this.myBaseMap.isEmpty();
    }

    public boolean containsKey(Key key) {
        return this.myBaseMap.containsKey(key);
    }
}

