/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.StringInterner;
import com.intellij.util.io.URLUtil;
import com.intellij.util.io.fs.IFile;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceReader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.jdom.filter.Filter;
import org.jdom.input.DOMBuilder;
import org.jdom.input.SAXBuilder;
import org.jdom.output.DOMOutputter;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDOMUtil {
    private static Logger ourLogger = null;
    private static ThreadLocal<SAXBuilder> ourSaxBuilder = new ThreadLocal<SAXBuilder>(){

        @Override
        protected SAXBuilder initialValue() {
            SAXBuilder saxBuilder = new SAXBuilder();
            saxBuilder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new CharArrayReader(ArrayUtil.EMPTY_CHAR_ARRAY));
                }
            });
            return saxBuilder;
        }
    };
    public static final String ENCODING = "UTF-8";
    private static final EmptyTextFilter CONTENT_FILTER = new EmptyTextFilter();

    private static Logger getLogger() {
        if (ourLogger == null) {
            ourLogger = Logger.getInstance("#com.intellij.openapi.util.JDOMUtil");
        }
        return ourLogger;
    }

    public static boolean areElementsEqual(org.jdom.Element e1, org.jdom.Element e2) {
        if (e1 == null && e2 == null) {
            return true;
        }
        if (e1 == null) {
            return false;
        }
        return JDOMUtil.attListsEqual(e1.getAttributes(), e2.getAttributes()) && JDOMUtil.contentListsEqual(e1.getContent((Filter)CONTENT_FILTER), e2.getContent((Filter)CONTENT_FILTER));
    }

    public static int getTreeHash(org.jdom.Element root) {
        return JDOMUtil.addToHash(0, root);
    }

    public static int getTreeHash(Document document) {
        return JDOMUtil.getTreeHash(document.getRootElement());
    }

    private static int addToHash(int i, org.jdom.Element element) {
        i = JDOMUtil.addToHash(i, element.getName());
        i = JDOMUtil.addToHash(i, element.getText());
        List list = element.getAttributes();
        for (int j = 0; j < list.size(); ++j) {
            Attribute attribute = (Attribute)list.get(j);
            i = JDOMUtil.addToHash(i, attribute);
        }
        List children = element.getChildren();
        for (org.jdom.Element child : children) {
            i = JDOMUtil.addToHash(i, child);
        }
        return i;
    }

    private static int addToHash(int i, Attribute attribute) {
        i = JDOMUtil.addToHash(i, attribute.getName());
        i = JDOMUtil.addToHash(i, attribute.getValue());
        return i;
    }

    private static int addToHash(int i, String s) {
        return i * 31 + s.hashCode();
    }

    public static Object[] getChildNodesWithAttrs(org.jdom.Element e) {
        ArrayList result = new ArrayList();
        result.addAll(e.getContent());
        result.addAll(e.getAttributes());
        return result.toArray(new Object[result.size()]);
    }

    public static Content[] getContent(org.jdom.Element m) {
        List list = m.getContent();
        return list.toArray(new Content[list.size()]);
    }

    public static org.jdom.Element[] getElements(org.jdom.Element m) {
        List list = m.getChildren();
        return list.toArray(new org.jdom.Element[list.size()]);
    }

    public static String concatTextNodesValues(Object[] nodes) {
        StringBuffer result = new StringBuffer();
        for (Object node : nodes) {
            result.append(((Content)node).getValue());
        }
        return result.toString();
    }

    public static void addContent(org.jdom.Element targetElement, Object node) {
        if (node instanceof Content) {
            Content content = (Content)node;
            targetElement.addContent(content);
        } else if (node instanceof List) {
            List list = (List)node;
            targetElement.addContent((Collection)list);
        } else {
            throw new IllegalArgumentException("Wrong node: " + node);
        }
    }

    public static void internElement(org.jdom.Element element, StringInterner interner) {
        element.setName(JDOMUtil.intern(interner, element.getName()));
        List attributes = element.getAttributes();
        for (Object o : attributes) {
            Attribute attr = (Attribute)o;
            attr.setName(JDOMUtil.intern(interner, attr.getName()));
            attr.setValue(JDOMUtil.intern(interner, attr.getValue()));
        }
        List content = element.getContent();
        for (Object o : content) {
            if (o instanceof org.jdom.Element) {
                org.jdom.Element e = (org.jdom.Element)o;
                JDOMUtil.internElement(e, interner);
                continue;
            }
            if (o instanceof Text) {
                Text text = (Text)o;
                text.setText(JDOMUtil.intern(interner, text.getText()));
                continue;
            }
            if (o instanceof Comment) {
                Comment comment = (Comment)o;
                comment.setText(JDOMUtil.intern(interner, comment.getText()));
                continue;
            }
            throw new IllegalArgumentException("Wrong node: " + o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String intern(StringInterner interner, String s) {
        StringInterner stringInterner = interner;
        synchronized (stringInterner) {
            return interner.intern(s);
        }
    }

    private static boolean contentListsEqual(List c1, List c2) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null) {
            return false;
        }
        ListIterator l1 = c1.listIterator();
        ListIterator l2 = c2.listIterator();
        while (l1.hasNext() && l2.hasNext()) {
            if (JDOMUtil.contentsEqual((Content)l1.next(), (Content)l2.next())) continue;
            return false;
        }
        return l1.hasNext() == l2.hasNext();
    }

    private static boolean contentsEqual(Content c1, Content c2) {
        if (!(c1 instanceof org.jdom.Element) && !(c2 instanceof org.jdom.Element)) {
            return c1.getValue().equals(c2.getValue());
        }
        return c1 instanceof org.jdom.Element && c2 instanceof org.jdom.Element && JDOMUtil.areElementsEqual((org.jdom.Element)c1, (org.jdom.Element)c2);
    }

    private static boolean attListsEqual(List a1, List a2) {
        if (a1.size() != a2.size()) {
            return false;
        }
        for (int i = 0; i < a1.size(); ++i) {
            if (JDOMUtil.attEqual((Attribute)a1.get(i), (Attribute)a2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean attEqual(Attribute a1, Attribute a2) {
        return a1.getName().equals(a2.getName()) && a1.getValue().equals(a2.getValue());
    }

    public static boolean areDocumentsEqual(Document d1, Document d2) {
        if (d1.hasRootElement() != d2.hasRootElement()) {
            return false;
        }
        if (!d1.hasRootElement()) {
            return true;
        }
        CharArrayWriter w1 = new CharArrayWriter();
        CharArrayWriter w2 = new CharArrayWriter();
        try {
            JDOMUtil.writeDocument(d1, w1, "\n");
            JDOMUtil.writeDocument(d2, w2, "\n");
        }
        catch (IOException e) {
            JDOMUtil.getLogger().error(e);
        }
        return w1.size() == w2.size() && w1.toString().equals(w2.toString());
    }

    public static Document loadDocument(char[] chars, int length) throws IOException, JDOMException {
        SAXBuilder builder = ourSaxBuilder.get();
        return builder.build((Reader)new CharArrayReader(chars, 0, length));
    }

    public static Document loadDocument(CharSequence seq) throws IOException, JDOMException {
        SAXBuilder builder = ourSaxBuilder.get();
        return builder.build((Reader)new CharSequenceReader(seq));
    }

    public static Document loadDocument(File file) throws JDOMException, IOException {
        return JDOMUtil.loadDocument(new BufferedInputStream(new FileInputStream(file)));
    }

    public static Document loadDocument(IFile iFile) throws IOException, JDOMException {
        return JDOMUtil.loadDocument(new BufferedInputStream(iFile.openInputStream()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document loadDocument(@NotNull InputStream stream) throws JDOMException, IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/JDOMUtil.loadDocument must not be null");
        }
        SAXBuilder saxBuilder = ourSaxBuilder.get();
        InputStreamReader reader = new InputStreamReader(stream, ENCODING);
        try {
            Document document = saxBuilder.build((Reader)reader);
            return document;
        }
        finally {
            reader.close();
        }
    }

    public static Document loadDocument(URL url) throws JDOMException, IOException {
        return JDOMUtil.loadDocument(URLUtil.openStream(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDocument(Document document, String filePath, String lineSeparator) throws IOException {
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(filePath));
        try {
            JDOMUtil.writeDocument(document, stream, lineSeparator);
        }
        finally {
            ((OutputStream)stream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDocument(Document document, File file, String lineSeparator) throws IOException {
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            JDOMUtil.writeDocument(document, stream, lineSeparator);
        }
        finally {
            ((OutputStream)stream).close();
        }
    }

    public static void writeDocument(Document document, OutputStream stream, String lineSeparator) throws IOException {
        JDOMUtil.writeDocument(document, new OutputStreamWriter(stream, ENCODING), lineSeparator);
    }

    public static byte[] printDocument(Document document, String lineSeparator) throws IOException {
        CharArrayWriter writer = new CharArrayWriter();
        JDOMUtil.writeDocument(document, writer, lineSeparator);
        return new String(writer.toCharArray()).getBytes(ENCODING);
    }

    public static String writeDocument(Document document, String lineSeparator) {
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.writeDocument(document, writer, lineSeparator);
            return writer.toString();
        }
        catch (IOException e) {
            return "";
        }
    }

    public static void writeElement(org.jdom.Element element, Writer writer, String lineSeparator) throws IOException {
        XMLOutputter xmlOutputter = JDOMUtil.createOutputter(lineSeparator);
        try {
            xmlOutputter.output(element, writer);
        }
        catch (NullPointerException ex) {
            JDOMUtil.getLogger().error(ex);
            JDOMUtil.printDiagnostics(element, "");
        }
    }

    public static String writeElement(org.jdom.Element element, String lineSeparator) throws IOException {
        StringWriter writer = new StringWriter();
        JDOMUtil.writeElement(element, writer, lineSeparator);
        return writer.toString();
    }

    public static void writeDocument(Document document, Writer writer, String lineSeparator) throws IOException {
        XMLOutputter xmlOutputter = JDOMUtil.createOutputter(lineSeparator);
        try {
            xmlOutputter.output(document, writer);
            writer.close();
        }
        catch (NullPointerException ex) {
            JDOMUtil.getLogger().error(ex);
            JDOMUtil.printDiagnostics(document.getRootElement(), "");
        }
    }

    public static XMLOutputter createOutputter(String lineSeparator) {
        MyXMLOutputter xmlOutputter = new MyXMLOutputter();
        Format format = Format.getCompactFormat().setIndent("  ").setTextMode(Format.TextMode.NORMALIZE).setEncoding(ENCODING).setOmitEncoding(false).setOmitDeclaration(false).setLineSeparator(lineSeparator);
        xmlOutputter.setFormat(format);
        return xmlOutputter;
    }

    @Nullable
    private static String escapeChar(char c, boolean escapeLineEnds) {
        switch (c) {
            case '\n': {
                return escapeLineEnds ? "&#10;" : null;
            }
            case '\r': {
                return escapeLineEnds ? "&#13;" : null;
            }
            case '\t': {
                return escapeLineEnds ? "&#9;" : null;
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '&': {
                return "&amp;";
            }
        }
        return null;
    }

    public static String escapeText(String text) {
        return JDOMUtil.escapeText(text, false);
    }

    private static String escapeText(String text, boolean escapeLineEnds) {
        StringBuffer buffer = null;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            String quotation = JDOMUtil.escapeChar(ch, escapeLineEnds);
            if (buffer == null) {
                if (quotation == null) continue;
                buffer = new StringBuffer(text.length() + 20);
                buffer.append(text.substring(0, i));
                buffer.append(quotation);
                continue;
            }
            if (quotation == null) {
                buffer.append(ch);
                continue;
            }
            buffer.append(quotation);
        }
        return buffer == null ? text : buffer.toString();
    }

    public static List<org.jdom.Element> getChildrenFromAllNamespaces(org.jdom.Element element, @NonNls String name) {
        ArrayList<org.jdom.Element> result = new ArrayList<org.jdom.Element>();
        List children = element.getChildren();
        for (Object aChildren : children) {
            org.jdom.Element child = (org.jdom.Element)aChildren;
            if (!name.equals(child.getName())) continue;
            result.add(child);
        }
        return result;
    }

    private static void printDiagnostics(org.jdom.Element element, String prefix) {
        ElementInfo info = JDOMUtil.getElementInfo(element);
        prefix = prefix + "/" + info.name;
        if (info.hasNullAttributes) {
            System.err.println(prefix);
        }
        List children = element.getChildren();
        for (org.jdom.Element child : children) {
            JDOMUtil.printDiagnostics(child, prefix);
        }
    }

    private static ElementInfo getElementInfo(org.jdom.Element element) {
        int length;
        ElementInfo info = new ElementInfo();
        StringBuffer buf = new StringBuffer(element.getName());
        List attributes = element.getAttributes();
        if (attributes != null && (length = attributes.size()) > 0) {
            buf.append("[");
            for (int idx = 0; idx < length; ++idx) {
                Attribute attr = (Attribute)attributes.get(idx);
                if (idx != 0) {
                    buf.append(";");
                }
                buf.append(attr.getName());
                buf.append("=");
                buf.append(attr.getValue());
                if (attr.getValue() != null) continue;
                info.hasNullAttributes = true;
            }
            buf.append("]");
        }
        info.name = buf.toString();
        return info;
    }

    public static void updateFileSet(File[] oldFiles, String[] newFilePaths, Document[] newFileDocuments, String lineSeparator) throws IOException {
        JDOMUtil.getLogger().assertTrue(newFilePaths.length == newFileDocuments.length);
        ArrayList<String> writtenFilesPaths = new ArrayList<String>();
        for (String newFilePath : newFilePaths) {
            File file = new File(newFilePath);
            if (!file.exists() || file.canWrite()) continue;
            throw new IOException("File \"" + newFilePath + "\" is not writeable");
        }
        for (File file : oldFiles) {
            if (!file.exists() || file.canWrite()) continue;
            throw new IOException("File \"" + file.getAbsolutePath() + "\" is not writeable");
        }
        for (int i = 0; i < newFilePaths.length; ++i) {
            String newFilePath = newFilePaths[i];
            JDOMUtil.writeDocument(newFileDocuments[i], newFilePath, lineSeparator);
            writtenFilesPaths.add(newFilePath);
        }
        block3: for (File oldFile : oldFiles) {
            String oldFilePath = oldFile.getAbsolutePath();
            for (String writtenFilesPath : writtenFilesPaths) {
                if (!oldFilePath.equals(writtenFilesPath)) continue;
                continue block3;
            }
            boolean result = oldFile.delete();
            if (result) continue;
            throw new IOException("File \"" + oldFilePath + "\" was not deleted");
        }
    }

    public static Element convertToDOM(@NotNull org.jdom.Element e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/JDOMUtil.convertToDOM must not be null");
        }
        try {
            Document d = new Document();
            org.jdom.Element newRoot = new org.jdom.Element(e.getName());
            List attributes = e.getAttributes();
            for (Object o : attributes) {
                Attribute attr = (Attribute)o;
                newRoot.setAttribute(attr.getName(), attr.getValue(), attr.getNamespace());
            }
            d.addContent((Content)newRoot);
            newRoot.addContent((Collection)e.cloneContent());
            return new DOMOutputter().output(d).getDocumentElement();
        }
        catch (JDOMException e1) {
            throw new RuntimeException(e1);
        }
    }

    public static org.jdom.Element convertFromDOM(Element e) {
        return new DOMBuilder().build(e);
    }

    public static String getValue(Object node) {
        if (node instanceof Content) {
            Content content = (Content)node;
            return content.getValue();
        }
        if (node instanceof Attribute) {
            Attribute attribute = (Attribute)node;
            return attribute.getValue();
        }
        throw new IllegalArgumentException("Wrong node: " + node);
    }

    private static class ElementInfo {
        public String name = "";
        public boolean hasNullAttributes = false;

        private ElementInfo() {
        }
    }

    public static class MyXMLOutputter
    extends XMLOutputter {
        public String escapeAttributeEntities(String str) {
            return JDOMUtil.escapeText(str, true);
        }

        public String escapeElementEntities(String str) {
            return JDOMUtil.escapeText(str, false);
        }
    }

    private static class EmptyTextFilter
    implements Filter {
        private EmptyTextFilter() {
        }

        public boolean matches(Object obj) {
            if (obj instanceof Text) {
                Text t = (Text)obj;
                return !CharArrayUtil.containsOnlyWhiteSpaces(t.getText());
            }
            return true;
        }
    }
}

