/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.reference.SoftReference;
import com.intellij.util.ImageLoader;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.containers.WeakHashMap;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.lang.ref.Reference;
import java.net.URL;
import java.util.Map;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.reflect.Reflection;

public final class IconLoader {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.IconLoader");
    private static final Color ourTransparentColor = new Color(0, 0, 0, 0);
    private static final ConcurrentHashMap<URL, Icon> ourIconsCache = new ConcurrentHashMap(100, 0.9f, 2);
    private static final Map<Icon, Icon> ourIcon2DisabledIcon = new WeakHashMap<Icon, Icon>(200);
    private static final JComponent ourFakeComponent = new JLabel();
    private static final ImageIcon EMPTY_ICON = new ImageIcon(new BufferedImage(1, 1, 5)){

        @NonNls
        public String toString() {
            return "Empty icon " + super.toString();
        }
    };
    private static boolean ourIsActivated = false;

    private IconLoader() {
    }

    @Deprecated
    public static Icon getIcon(Image image) {
        LOG.assertTrue(image != null);
        return new MyImageIcon(image);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Icon getIcon(@NonNls String path) {
        int stackFrameCount = 2;
        Class callerClass = Reflection.getCallerClass((int)stackFrameCount);
        while (callerClass != null && callerClass.getClassLoader() == null) {
            callerClass = Reflection.getCallerClass((int)(++stackFrameCount));
        }
        if (callerClass == null) {
            callerClass = Reflection.getCallerClass((int)1);
        }
        Icon icon = IconLoader.getIcon(path, callerClass);
        if (icon == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/IconLoader.getIcon must not return null");
        }
        return icon;
    }

    @Nullable
    public static Icon findIcon(@NonNls String path) {
        int stackFrameCount = 2;
        Class callerClass = Reflection.getCallerClass((int)stackFrameCount);
        while (callerClass != null && callerClass.getClassLoader() == null) {
            callerClass = Reflection.getCallerClass((int)(++stackFrameCount));
        }
        if (callerClass == null) {
            callerClass = Reflection.getCallerClass((int)1);
        }
        return IconLoader.findIcon(path, callerClass);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Icon getIcon(String path, Class aClass) {
        Icon icon = IconLoader.findIcon(path, aClass);
        if (icon == null) {
            LOG.error("Icon cannot be found in '" + path + "', aClass='" + (aClass == null ? null : aClass.getName()) + "'");
        }
        Icon icon2 = icon;
        if (icon2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/IconLoader.getIcon must not return null");
        }
        return icon2;
    }

    public static void activate() {
        ourIsActivated = true;
    }

    private static boolean isLoaderDisabled() {
        return !ourIsActivated;
    }

    @Nullable
    public static Icon findIcon(@NotNull String path, @NotNull Class aClass) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/IconLoader.findIcon must not be null");
        }
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/IconLoader.findIcon must not be null");
        }
        URL url = aClass.getResource(path);
        return IconLoader.findIcon(url);
    }

    @Nullable
    private static Icon findIcon(URL url) {
        if (url == null) {
            return null;
        }
        Icon icon = ourIconsCache.get(url);
        if (icon == null) {
            icon = new CachedImageIcon(url);
            icon = ourIconsCache.cacheOrGet(url, icon);
        }
        return icon;
    }

    @Nullable
    public static Icon findIcon(String path, ClassLoader aClassLoader) {
        if (!path.startsWith("/")) {
            return null;
        }
        URL url = aClassLoader.getResource(path.substring(1));
        return IconLoader.findIcon(url);
    }

    @Nullable
    private static Icon checkIcon(Image image, URL url) {
        if (image == null || image.getHeight(ourFakeComponent) < 1) {
            return null;
        }
        Icon icon = IconLoader.getIcon(image);
        if (icon != null && !ImageLoader.isGoodSize(icon)) {
            LOG.error("Invalid icon: " + url);
            return EMPTY_ICON;
        }
        return icon;
    }

    @Nullable
    public static Icon getDisabledIcon(Icon icon) {
        if (icon == null) {
            return null;
        }
        Icon disabledIcon = ourIcon2DisabledIcon.get(icon);
        if (disabledIcon == null) {
            if (!ImageLoader.isGoodSize(icon)) {
                LOG.error(icon.toString());
                return EMPTY_ICON;
            }
            BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            Graphics2D graphics = image.createGraphics();
            graphics.setColor(ourTransparentColor);
            graphics.fillRect(0, 0, icon.getIconWidth(), icon.getIconHeight());
            icon.paintIcon(ourFakeComponent, graphics, 0, 0);
            graphics.dispose();
            disabledIcon = new MyImageIcon(GrayFilter.createDisabledImage(image));
            ourIcon2DisabledIcon.put(icon, disabledIcon);
        }
        return disabledIcon;
    }

    public static Icon getTransparentIcon(Icon icon) {
        return IconLoader.getTransparentIcon(icon, 0.5f);
    }

    public static Icon getTransparentIcon(final Icon icon, final float alpha) {
        return new Icon(){

            public int getIconHeight() {
                return icon.getIconHeight();
            }

            public int getIconWidth() {
                return icon.getIconWidth();
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2 = (Graphics2D)g;
                Composite saveComposite = g2.getComposite();
                g2.setComposite(AlphaComposite.getInstance(10, alpha));
                icon.paintIcon(c, g2, x, y);
                g2.setComposite(saveComposite);
            }
        };
    }

    private static final class MyImageIcon
    extends ImageIcon {
        public MyImageIcon(Image image) {
            super(image);
        }

        public final synchronized void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(null, g, x, y);
        }
    }

    private static final class CachedImageIcon
    implements Icon {
        private Object myRealIcon;
        private URL myUrl;

        public CachedImageIcon(URL url) {
            this.myUrl = url;
        }

        private synchronized Icon getRealIcon() {
            Icon icon;
            if (IconLoader.isLoaderDisabled()) {
                return EMPTY_ICON;
            }
            if (this.myRealIcon instanceof Icon) {
                return (Icon)this.myRealIcon;
            }
            if (this.myRealIcon instanceof Reference && (icon = (Icon)((Reference)this.myRealIcon).get()) != null) {
                return icon;
            }
            Image image = ImageLoader.loadFromUrl(this.myUrl);
            icon = IconLoader.checkIcon(image, this.myUrl);
            if (icon != null) {
                this.myRealIcon = icon.getIconWidth() < 50 && icon.getIconHeight() < 50 ? icon : new SoftReference<Icon>(icon);
            }
            return icon != null ? icon : EMPTY_ICON;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.getRealIcon().paintIcon(c, g, x, y);
        }

        public int getIconWidth() {
            return this.getRealIcon().getIconWidth();
        }

        public int getIconHeight() {
            return this.getRealIcon().getIconHeight();
        }
    }
}

