/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.util.concurrency.JBLock;
import com.intellij.util.concurrency.JBReentrantReadWriteLock;
import com.intellij.util.concurrency.LockFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FieldCache<T, Owner, AccessorParameter, Parameter> {
    private JBReentrantReadWriteLock ourLock = LockFactory.createReadWriteLock();
    private JBLock r = this.ourLock.readLock();
    private JBLock w = this.ourLock.writeLock();

    protected FieldCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T get(AccessorParameter a, Owner owner, Parameter p) {
        T result;
        this.r.lock();
        try {
            result = this.getValue(owner, a);
        }
        finally {
            this.r.unlock();
        }
        if (result == null) {
            this.w.lock();
            try {
                result = this.getValue(owner, a);
                if (result == null) {
                    result = this.compute(owner, p);
                    this.putValue(result, owner, a);
                }
            }
            finally {
                this.w.unlock();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T getCached(AccessorParameter a, Owner owner) {
        this.r.lock();
        try {
            T t = this.getValue(owner, a);
            return t;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear(AccessorParameter a, Owner owner) {
        this.w.lock();
        try {
            this.putValue(null, owner, a);
        }
        finally {
            this.w.unlock();
        }
    }

    protected abstract T compute(Owner var1, Parameter var2);

    protected abstract T getValue(Owner var1, AccessorParameter var2);

    protected abstract void putValue(T var1, Owner var2, AccessorParameter var3);
}

