/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.ActionCallback;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class ExecutionCallback {
    private boolean myExecuted;
    private List<Runnable> myRunnables;

    ExecutionCallback() {
    }

    public void setExecuted() {
        this.myExecuted = true;
        this.callback();
    }

    final void doWhenExecuted(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/ExecutionCallback.doWhenExecuted must not be null");
        }
        if (this.myRunnables == null) {
            this.myRunnables = new ArrayList<Runnable>();
        }
        this.myRunnables.add(runnable);
        this.callback();
    }

    final void notifyWhenExecuted(final ActionCallback child) {
        this.doWhenExecuted(new Runnable(){

            public void run() {
                child.setDone();
            }
        });
    }

    private void callback() {
        if (this.myExecuted && this.myRunnables != null) {
            Runnable[] all = this.myRunnables.toArray(new Runnable[this.myRunnables.size()]);
            this.myRunnables.clear();
            for (Runnable each : all) {
                each.run();
            }
        }
    }
}

