/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.CommonBundle;
import com.intellij.openapi.util.SystemInfo;
import java.io.IOException;
import java.util.HashMap;

public class ExceptionMessages {
    static final HashMap<Integer, String> ourIOMessages = new HashMap();

    public static String getMessage(IOException exception) {
        String exceptionMessage = exception.getMessage();
        String detailedMessage = null;
        int idx = exceptionMessage.indexOf(61);
        if (idx != -1) {
            int endIdx;
            for (endIdx = idx + 1; endIdx < exceptionMessage.length() && Character.isDigit(exceptionMessage.charAt(endIdx)); ++endIdx) {
            }
            try {
                int errorNumber = Integer.parseInt(exceptionMessage.substring(idx + 1, endIdx));
                detailedMessage = ourIOMessages.get(new Integer(errorNumber));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        StringBuffer buf = new StringBuffer();
        buf.append(exceptionMessage);
        if (detailedMessage != null) {
            buf.append("\n");
            buf.append(detailedMessage);
        }
        return buf.toString();
    }

    static {
        if (SystemInfo.isWindows) {
            ourIOMessages.put(new Integer(1), CommonBundle.message("incorrect.function.error.message", new Object[0]));
            ourIOMessages.put(new Integer(2), CommonBundle.message("the.system.cannot.find.the.file.specified.error.message", new Object[0]));
            ourIOMessages.put(new Integer(3), CommonBundle.message("the.system.cannot.find.the.path.specified.error.message", new Object[0]));
            ourIOMessages.put(new Integer(4), CommonBundle.message("the.system.cannot.open.the.file.error.message", new Object[0]));
            ourIOMessages.put(new Integer(5), CommonBundle.message("access.is.denied.error.message", new Object[0]));
            ourIOMessages.put(new Integer(6), CommonBundle.message("the.handle.is.invalid.error.message", new Object[0]));
            ourIOMessages.put(new Integer(7), CommonBundle.message("the.storage.control.blocks.were.destroyed.error.message", new Object[0]));
            ourIOMessages.put(new Integer(8), CommonBundle.message("not.enough.storage.is.available.to.process.this.command.error.message", new Object[0]));
            ourIOMessages.put(new Integer(9), CommonBundle.message("the.storage.control.block.address.is.invalid.error.message", new Object[0]));
            ourIOMessages.put(new Integer(10), CommonBundle.message("the.environment.is.incorrect.error.message", new Object[0]));
            ourIOMessages.put(new Integer(11), CommonBundle.message("an.attempt.was.made.to.load.a.program.with.an.incorrect.format.error.message", new Object[0]));
            ourIOMessages.put(new Integer(12), CommonBundle.message("the.access.code.is.invalid.error.message", new Object[0]));
            ourIOMessages.put(new Integer(13), CommonBundle.message("the.data.is.invalid.error.message", new Object[0]));
            ourIOMessages.put(new Integer(14), CommonBundle.message("not.enough.storage.is.available.to.complete.this.operation.error.message", new Object[0]));
            ourIOMessages.put(new Integer(15), CommonBundle.message("the.system.cannot.find.the.drive.specified.error.message", new Object[0]));
            ourIOMessages.put(new Integer(16), CommonBundle.message("the.directory.cannot.be.removed.error.message", new Object[0]));
            ourIOMessages.put(new Integer(17), CommonBundle.message("the.system.cannot.move.the.file.to.a.different.disk.drive.error.message", new Object[0]));
            ourIOMessages.put(new Integer(18), CommonBundle.message("there.are.no.more.files.error.message", new Object[0]));
            ourIOMessages.put(new Integer(19), CommonBundle.message("the.media.is.write.protected.error.message", new Object[0]));
            ourIOMessages.put(new Integer(20), CommonBundle.message("the.system.cannot.find.the.device.specified.error.message", new Object[0]));
            ourIOMessages.put(new Integer(21), CommonBundle.message("the.device.is.not.ready.error.message", new Object[0]));
            ourIOMessages.put(new Integer(22), CommonBundle.message("the.device.does.not.recognize.the.command.error.message", new Object[0]));
            ourIOMessages.put(new Integer(23), CommonBundle.message("data.error.cyclic.redundancy.check.error.message", new Object[0]));
            ourIOMessages.put(new Integer(24), CommonBundle.message("the.program.issued.a.command.but.the.command.length.is.incorrect.error.message", new Object[0]));
            ourIOMessages.put(new Integer(25), CommonBundle.message("the.drive.cannot.locate.a.specific.area.or.track.on.the.disk.error.message", new Object[0]));
            ourIOMessages.put(new Integer(26), CommonBundle.message("the.specified.disk.or.diskette.cannot.be.accessed.error.message", new Object[0]));
            ourIOMessages.put(new Integer(27), CommonBundle.message("the.drive.cannot.find.the.sector.requested.error.message", new Object[0]));
        }
    }
}

