/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.objectTree.ObjectNode;
import com.intellij.openapi.util.objectTree.ObjectTree;
import com.intellij.openapi.util.objectTree.ObjectTreeAction;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Disposer {
    private static final ObjectTree ourTree = new ObjectTree();
    private static final ObjectTreeAction ourDisposeAction = new ObjectTreeAction(){

        public void execute(Object each) {
            ((Disposable)each).dispose();
        }

        public void beforeTreeExecution(Object parent) {
            if (parent instanceof Disposable.Parent) {
                ((Disposable.Parent)parent).beforeTreeDispose();
            }
        }
    };
    private static boolean ourDebugMode;
    private static final Map<String, Disposable> ourKeyDisposables;

    private Disposer() {
    }

    public static void register(@NotNull Disposable parent, @NotNull Disposable child) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/Disposer.register must not be null");
        }
        if (child == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/Disposer.register must not be null");
        }
        Disposer.register(parent, child, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(@NotNull Disposable parent, @NotNull Disposable child, final @NonNls @Nullable String key) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/Disposer.register must not be null");
        }
        if (child == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/util/Disposer.register must not be null");
        }
        assert (parent != child) : " Cannot register to itself";
        ObjectTree objectTree = ourTree;
        synchronized (objectTree) {
            ourTree.register(parent, child);
            if (key == null) {
                return;
            }
            assert (Disposer.get(key) == null);
            ourKeyDisposables.put(key, child);
            Disposer.register(child, new Disposable(){

                public void dispose() {
                    ourKeyDisposables.remove(key);
                }
            });
        }
    }

    public static boolean isDisposed(Disposable disposable) {
        return !Disposer.getTree().getObject2NodeMap().containsKey(disposable);
    }

    public static Disposable get(String key) {
        return ourKeyDisposables.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dispose(Disposable disposable) {
        ObjectTree objectTree = ourTree;
        synchronized (objectTree) {
            ourTree.executeAll(disposable, true, ourDisposeAction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeChildAndReplace(Disposable toDipose, Disposable toReplace) {
        ObjectTree objectTree = ourTree;
        synchronized (objectTree) {
            ourTree.executeChildAndReplace(toDipose, toReplace, true, ourDisposeAction);
        }
    }

    static ObjectTree getTree() {
        return ourTree;
    }

    public static void assertIsEmpty() {
        boolean firstObject = true;
        Set objects = ourTree.getRootObjects();
        for (Object object : objects) {
            ObjectNode objectNode;
            if (object == null || (objectNode = ourTree.getObject2NodeMap().get(object)) == null) continue;
            if (firstObject) {
                firstObject = false;
                System.err.println("***********************************************************************************************");
                System.err.println("***                        M E M O R Y    L E A K S   D E T E C T E D                       ***");
                System.err.println("***********************************************************************************************");
                System.err.println("***                                                                                         ***");
                System.err.println("***   The following objects were not disposed: ");
            }
            System.err.println("***   " + object + " of class " + object.getClass());
            Throwable trace = objectNode.getTrace();
            if (trace == null) continue;
            System.err.println("***         First seen at: ");
            trace.printStackTrace();
        }
        if (!firstObject) {
            System.err.println("***                                                                                         ***");
            System.err.println("***********************************************************************************************");
        }
    }

    public static void setDebugMode(boolean b) {
        ourDebugMode = b;
    }

    public static boolean isDebugMode() {
        return ourDebugMode;
    }

    static {
        ourKeyDisposables = new WeakHashMap<String, Disposable>();
    }
}

