/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.ReflectionCache;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.List;
import org.jdom.Element;
import org.jdom.Verifier;
import org.jetbrains.annotations.Nullable;

public class DefaultJDOMExternalizer {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.DefaultJDOMExternalizer");

    private DefaultJDOMExternalizer() {
    }

    public static void writeExternal(Object data, Element parentNode) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal(data, parentNode, null);
    }

    public static void writeExternal(Object data, Element parentNode, JDOMFilter filter) throws WriteExternalException {
        Field[] fields;
        for (Field field : fields = data.getClass().getFields()) {
            Element element;
            String value;
            block22: {
                if (field.getName().indexOf(36) >= 0) continue;
                int modifiers = field.getModifiers();
                value = null;
                if ((modifiers & 1) == 0 || (modifiers & 8) != 0) continue;
                field.setAccessible(true);
                Class<?> type = field.getType();
                if (filter != null && !filter.isAccept(field)) continue;
                try {
                    if (type.isPrimitive()) {
                        if (type.equals(Byte.TYPE)) {
                            value = Byte.toString(field.getByte(data));
                        } else if (type.equals(Short.TYPE)) {
                            value = Short.toString(field.getShort(data));
                        } else if (type.equals(Integer.TYPE)) {
                            value = Integer.toString(field.getInt(data));
                        } else if (type.equals(Long.TYPE)) {
                            value = Long.toString(field.getLong(data));
                        } else if (type.equals(Float.TYPE)) {
                            value = Float.toString(field.getFloat(data));
                        } else if (type.equals(Double.TYPE)) {
                            value = Double.toString(field.getDouble(data));
                        } else if (type.equals(Character.TYPE)) {
                            value = String.valueOf(field.getChar(data));
                        } else {
                            if (!type.equals(Boolean.TYPE)) continue;
                            value = Boolean.toString(field.getBoolean(data));
                        }
                        break block22;
                    }
                    if (type.equals(String.class)) {
                        value = DefaultJDOMExternalizer.filterXMLCharacters((String)field.get(data));
                        break block22;
                    }
                    if (type.equals(Color.class)) {
                        Color color = (Color)field.get(data);
                        if (color != null) {
                            value = Integer.toString(color.getRGB() & 0xFFFFFF, 16);
                        }
                        break block22;
                    }
                    if (ReflectionCache.isAssignable(JDOMExternalizable.class, type)) {
                        element = new Element("option");
                        parentNode.addContent(element);
                        element.setAttribute("name", field.getName());
                        JDOMExternalizable domValue = (JDOMExternalizable)field.get(data);
                        if (domValue == null) continue;
                        Element valueElement = new Element("value");
                        element.addContent(valueElement);
                        domValue.writeExternal(valueElement);
                        continue;
                    }
                    LOG.debug("Wrong field type: " + type);
                }
                catch (IllegalAccessException e) {}
                continue;
            }
            element = new Element("option");
            parentNode.addContent(element);
            element.setAttribute("name", field.getName());
            if (value == null) continue;
            element.setAttribute("value", value);
        }
    }

    @Nullable
    public static String filterXMLCharacters(String value) {
        if (value != null) {
            StringBuilder builder = null;
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (Verifier.isXMLCharacter((int)c)) {
                    if (builder == null) continue;
                    builder.append(c);
                    continue;
                }
                if (builder != null) continue;
                builder = new StringBuilder(value.length() + 5);
                builder.append(value, 0, i);
            }
            if (builder != null) {
                value = builder.toString();
            }
        }
        return value;
    }

    public static void readExternal(Object data, Element parentNode) throws InvalidDataException {
        if (parentNode == null) {
            return;
        }
        for (Object o : parentNode.getChildren("option")) {
            Element e = (Element)o;
            String fieldName = e.getAttributeValue("name");
            if (fieldName == null) {
                throw new InvalidDataException();
            }
            try {
                Field field = data.getClass().getField(fieldName);
                Class<?> type = field.getType();
                int modifiers = field.getModifiers();
                if ((modifiers & 1) == 0 || (modifiers & 8) != 0 || (modifiers & 0x10) != 0) continue;
                field.setAccessible(true);
                String value = e.getAttributeValue("value");
                if (type.isPrimitive()) {
                    if (value == null) continue;
                    if (type.equals(Byte.TYPE)) {
                        try {
                            field.setByte(data, Byte.parseByte(value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type.equals(Short.TYPE)) {
                        try {
                            field.setShort(data, Short.parseShort(value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type.equals(Integer.TYPE)) {
                        try {
                            field.setInt(data, Integer.parseInt(value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type.equals(Long.TYPE)) {
                        try {
                            field.setLong(data, Long.parseLong(value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type.equals(Float.TYPE)) {
                        try {
                            field.setFloat(data, Float.parseFloat(value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type.equals(Double.TYPE)) {
                        try {
                            field.setDouble(data, Double.parseDouble(value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type.equals(Character.TYPE)) {
                        if (value.length() != 1) {
                            throw new InvalidDataException();
                        }
                        field.setChar(data, value.charAt(0));
                        continue;
                    }
                    if (type.equals(Boolean.TYPE)) {
                        if (value.equals("true")) {
                            field.setBoolean(data, true);
                            continue;
                        }
                        if (value.equals("false")) {
                            field.setBoolean(data, false);
                            continue;
                        }
                        throw new InvalidDataException();
                    }
                    throw new InvalidDataException();
                }
                if (type.equals(String.class)) {
                    field.set(data, value);
                    continue;
                }
                if (type.equals(Color.class)) {
                    if (value != null) {
                        try {
                            int rgb = Integer.parseInt(value, 16);
                            field.set(data, new Color(rgb));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            LOG.debug("Wrong color value: " + value, ex);
                            throw new InvalidDataException();
                        }
                    }
                    field.set(data, null);
                    continue;
                }
                if (ReflectionCache.isAssignable(JDOMExternalizable.class, type)) {
                    List children = e.getChildren("value");
                    if (children.isEmpty()) continue;
                    JDOMExternalizable object = null;
                    for (Object o1 : children) {
                        Element el = (Element)o1;
                        object = (JDOMExternalizable)type.newInstance();
                        object.readExternal(el);
                    }
                    field.set(data, object);
                    continue;
                }
                throw new InvalidDataException("wrong type: " + type);
            }
            catch (NoSuchFieldException ex) {
                LOG.debug(ex);
            }
            catch (SecurityException ex) {
                throw new InvalidDataException();
            }
            catch (IllegalAccessException ex) {
                throw new InvalidDataException(ex);
            }
            catch (InstantiationException ex) {
                throw new InvalidDataException();
            }
        }
    }

    public static interface JDOMFilter {
        public boolean isAccept(Field var1);
    }
}

