/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Condition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Conditions {
    public static Condition<Object> TRUE = new Condition<Object>(){

        @Override
        public boolean value(Object object) {
            return true;
        }
    };
    public static Condition<Object> FALSE = new Condition<Object>(){

        @Override
        public boolean value(Object object) {
            return false;
        }
    };

    private Conditions() {
    }

    public static <T> Condition<T> alwaysTrue() {
        return TRUE;
    }

    public static <T> Condition<T> alwaysFalse() {
        return FALSE;
    }

    public static <T> Condition<T> not(Condition<T> c) {
        return new Not<T>(c);
    }

    public static <T> Condition<T> and(Condition<T> c1, Condition<T> c2) {
        return new And<T>(c1, c2);
    }

    public static <T> Condition<T> or(Condition<T> c1, Condition<T> c2) {
        return new Or<T>(c1, c2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Or<T>
    implements Condition<T> {
        private Condition<T> t1;
        private Condition<T> t2;

        public Or(Condition<T> t1, Condition<T> t2) {
            this.t1 = t1;
            this.t2 = t2;
        }

        @Override
        public boolean value(T object) {
            return this.t1.value(object) || this.t2.value(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class And<T>
    implements Condition<T> {
        private Condition<T> t1;
        private Condition<T> t2;

        public And(Condition<T> t1, Condition<T> t2) {
            this.t1 = t1;
            this.t2 = t2;
        }

        @Override
        public boolean value(T object) {
            return this.t1.value(object) && this.t2.value(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Not<T>
    implements Condition<T> {
        private final Condition<T> myCondition;

        public Not(Condition<T> condition) {
            this.myCondition = condition;
        }

        @Override
        public boolean value(T value) {
            return !this.myCondition.value(value);
        }
    }
}

