/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.popup;

import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.treetable.TreeTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PopupChooserBuilder {
    private JComponent myChooserComponent;
    private String myTitle;
    private ArrayList<KeyStroke> myAdditionalKeystrokes;
    private Runnable myItemChoosenRunnable;
    private JComponent mySouthComponent;
    private JBPopup myPopup;
    private boolean myRequestFocus;
    private boolean myForceResizable;
    private boolean myForceMovable;
    private String myDimensionServiceKey;
    private Computable<Boolean> myCancelCallback;
    private boolean myAutoselect;
    private float myAlpha;
    private Component[] myFocusOwners;
    private boolean myCancelKeyEnabled;
    ArrayList<JBPopupListener> myListeners;

    public PopupChooserBuilder(@NotNull JList list) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/ui/popup/PopupChooserBuilder.<init> must not be null");
        }
        this.myAdditionalKeystrokes = new ArrayList();
        this.myRequestFocus = true;
        this.myForceResizable = false;
        this.myForceMovable = false;
        this.myDimensionServiceKey = null;
        this.myAutoselect = true;
        this.myFocusOwners = new Component[0];
        this.myCancelKeyEnabled = true;
        this.myListeners = new ArrayList();
        this.myChooserComponent = new MyListWrapper(list);
    }

    public PopupChooserBuilder(@NotNull JTable table) {
        if (table == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/ui/popup/PopupChooserBuilder.<init> must not be null");
        }
        this.myAdditionalKeystrokes = new ArrayList();
        this.myRequestFocus = true;
        this.myForceResizable = false;
        this.myForceMovable = false;
        this.myDimensionServiceKey = null;
        this.myAutoselect = true;
        this.myFocusOwners = new Component[0];
        this.myCancelKeyEnabled = true;
        this.myListeners = new ArrayList();
        this.myChooserComponent = table;
    }

    public PopupChooserBuilder(@NotNull JTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/ui/popup/PopupChooserBuilder.<init> must not be null");
        }
        this.myAdditionalKeystrokes = new ArrayList();
        this.myRequestFocus = true;
        this.myForceResizable = false;
        this.myForceMovable = false;
        this.myDimensionServiceKey = null;
        this.myAutoselect = true;
        this.myFocusOwners = new Component[0];
        this.myCancelKeyEnabled = true;
        this.myListeners = new ArrayList();
        this.myChooserComponent = tree;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PopupChooserBuilder setTitle(@NotNull @Nls String title) {
        if (title == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/ui/popup/PopupChooserBuilder.setTitle must not be null");
        }
        this.myTitle = title;
        PopupChooserBuilder popupChooserBuilder = this;
        if (popupChooserBuilder == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/ui/popup/PopupChooserBuilder.setTitle must not return null");
        }
        return popupChooserBuilder;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PopupChooserBuilder addAdditionalChooseKeystroke(@Nullable KeyStroke keyStroke) {
        if (keyStroke != null) {
            this.myAdditionalKeystrokes.add(keyStroke);
        }
        PopupChooserBuilder popupChooserBuilder = this;
        if (popupChooserBuilder == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/ui/popup/PopupChooserBuilder.addAdditionalChooseKeystroke must not return null");
        }
        return popupChooserBuilder;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PopupChooserBuilder setItemChoosenCallback(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/ui/popup/PopupChooserBuilder.setItemChoosenCallback must not be null");
        }
        this.myItemChoosenRunnable = runnable;
        PopupChooserBuilder popupChooserBuilder = this;
        if (popupChooserBuilder == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/ui/popup/PopupChooserBuilder.setItemChoosenCallback must not return null");
        }
        return popupChooserBuilder;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PopupChooserBuilder setSouthComponent(@NotNull JComponent cmp) {
        if (cmp == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/ui/popup/PopupChooserBuilder.setSouthComponent must not be null");
        }
        this.mySouthComponent = cmp;
        PopupChooserBuilder popupChooserBuilder = this;
        if (popupChooserBuilder == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/ui/popup/PopupChooserBuilder.setSouthComponent must not return null");
        }
        return popupChooserBuilder;
    }

    public PopupChooserBuilder setRequestFocus(boolean requestFocus) {
        this.myRequestFocus = requestFocus;
        return this;
    }

    public PopupChooserBuilder setResizable(boolean forceResizable) {
        this.myForceResizable = forceResizable;
        return this;
    }

    public PopupChooserBuilder setMovable(boolean forceMovable) {
        this.myForceMovable = forceMovable;
        return this;
    }

    public PopupChooserBuilder setDimensionServiceKey(@NonNls String key) {
        this.myDimensionServiceKey = key;
        return this;
    }

    public PopupChooserBuilder setCancelCalllback(Computable<Boolean> callback) {
        this.myCancelCallback = callback;
        return this;
    }

    public PopupChooserBuilder setAlpha(float alpha) {
        this.myAlpha = alpha;
        return this;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public JBPopup createPopup() {
        void var2_9;
        JList jList;
        JPanel contentPane = new JPanel(new BorderLayout());
        if (!this.myForceMovable && this.myTitle != null) {
            JLabel jLabel = new JLabel(this.myTitle);
            jLabel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
            jLabel.setHorizontalAlignment(0);
            contentPane.add((Component)jLabel, "North");
        }
        if (this.myChooserComponent instanceof MyListWrapper && (jList = ((MyListWrapper)this.myChooserComponent).myList).getSelectedIndex() == -1 && this.myAutoselect) {
            jList.setSelectedIndex(0);
        }
        this.myChooserComponent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.myChooserComponent.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (!e.isConsumed()) {
                    PopupChooserBuilder.this.closePopup(true);
                }
            }
        });
        this.regsiterClosePopupKeyboardAction(KeyStroke.getKeyStroke(27, 0), false);
        this.regsiterClosePopupKeyboardAction(KeyStroke.getKeyStroke(10, 0), true);
        for (KeyStroke keystroke : this.myAdditionalKeystrokes) {
            this.regsiterClosePopupKeyboardAction(keystroke, true);
        }
        if (this.myChooserComponent instanceof MyListWrapper) {
            MyListWrapper myListWrapper = (MyListWrapper)this.myChooserComponent;
        } else if (this.myChooserComponent instanceof JTable) {
            JScrollPane jScrollPane = PopupChooserBuilder.createScrollPane((JTable)this.myChooserComponent);
        } else {
            if (!(this.myChooserComponent instanceof JTree)) {
                throw new IllegalStateException("PopupChooserBuilder is intended to be constructed with one of JTable, JTree, JList components");
            }
            JScrollPane jScrollPane = PopupChooserBuilder.createScrollPane((JTree)this.myChooserComponent);
        }
        var2_9.getViewport().setCursor(Cursor.getPredefinedCursor(12));
        contentPane.add((Component)var2_9, "Center");
        if (this.mySouthComponent != null) {
            contentPane.add((Component)this.mySouthComponent, "South");
        }
        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder(contentPane, this.myChooserComponent);
        for (JBPopupListener each : this.myListeners) {
            builder.addListener(each);
        }
        JBPopup jBPopup = this.myPopup = builder.setDimensionServiceKey(null, this.myDimensionServiceKey, false).setRequestFocus(this.myRequestFocus).setResizable(this.myForceResizable).setMovable(this.myForceMovable).setTitle(this.myForceMovable ? this.myTitle : null).setCancelCallback(this.myCancelCallback).setAlpha(this.myAlpha).setFocusOwners(this.myFocusOwners).setCancelKeyEnabled(this.myCancelKeyEnabled).createPopup();
        if (jBPopup == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/ui/popup/PopupChooserBuilder.createPopup must not return null");
        }
        return jBPopup;
    }

    private void regsiterClosePopupKeyboardAction(KeyStroke keyStroke, final boolean shouldPerformAction) {
        this.myChooserComponent.registerKeyboardAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                PopupChooserBuilder.this.closePopup(shouldPerformAction);
            }
        }, keyStroke, 1);
    }

    private void closePopup(boolean shouldPerformAction) {
        this.myPopup.cancel();
        if (shouldPerformAction && this.myItemChoosenRunnable != null) {
            this.myItemChoosenRunnable.run();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static JScrollPane createScrollPane(final JTable table) {
        if (table instanceof TreeTable) {
            TreeUtil.expandAll(((TreeTable)table).getTree());
        }
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        if (table.getSelectedRow() == -1) {
            table.getSelectionModel().setSelectionInterval(0, 0);
        }
        if (table.getRowCount() >= 20) {
            scrollPane.getViewport().setPreferredSize(new Dimension(table.getPreferredScrollableViewportSize().width, 300));
        } else {
            scrollPane.getViewport().setPreferredSize(table.getPreferredSize());
        }
        table.addMouseMotionListener(new MouseMotionAdapter(){
            boolean myIsEngaged = false;

            public void mouseMoved(MouseEvent e) {
                if (this.myIsEngaged) {
                    int index = table.rowAtPoint(e.getPoint());
                    table.getSelectionModel().setSelectionInterval(index, index);
                } else {
                    this.myIsEngaged = true;
                }
            }
        });
        JScrollPane jScrollPane = scrollPane;
        if (jScrollPane == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/ui/popup/PopupChooserBuilder.createScrollPane must not return null");
        }
        return jScrollPane;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static JScrollPane createScrollPane(final JTree tree) {
        TreeUtil.expandAll(tree);
        JScrollPane scrollPane = new JScrollPane(tree);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        if (tree.getSelectionCount() == 0) {
            tree.setSelectionRow(0);
        }
        if (tree.getRowCount() >= 20) {
            scrollPane.getViewport().setPreferredSize(new Dimension(tree.getPreferredScrollableViewportSize().width, 300));
        } else {
            scrollPane.getViewport().setPreferredSize(tree.getPreferredSize());
        }
        tree.addMouseMotionListener(new MouseMotionAdapter(){
            boolean myIsEngaged = false;

            public void mouseMoved(MouseEvent e) {
                if (this.myIsEngaged) {
                    Point p = e.getPoint();
                    int index = tree.getRowForLocation(p.x, p.y);
                    tree.setSelectionRow(index);
                } else {
                    this.myIsEngaged = true;
                }
            }
        });
        JScrollPane jScrollPane = scrollPane;
        if (jScrollPane == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/ui/popup/PopupChooserBuilder.createScrollPane must not return null");
        }
        return jScrollPane;
    }

    public PopupChooserBuilder setAutoSelectIfEmpty(boolean autoselect) {
        this.myAutoselect = autoselect;
        return this;
    }

    public PopupChooserBuilder setCancelKeyEnabled(boolean enabled) {
        this.myCancelKeyEnabled = enabled;
        return this;
    }

    public void addListener(JBPopupListener listener) {
        this.myListeners.add(listener);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PopupChooserBuilder setFocusOwners(@NotNull Component[] focusOwners) {
        if (focusOwners == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/ui/popup/PopupChooserBuilder.setFocusOwners must not be null");
        }
        this.myFocusOwners = focusOwners;
        PopupChooserBuilder popupChooserBuilder = this;
        if (popupChooserBuilder == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/ui/popup/PopupChooserBuilder.setFocusOwners must not return null");
        }
        return popupChooserBuilder;
    }

    private class MyListWrapper
    extends JScrollPane
    implements DataProvider {
        private JList myList;

        public MyListWrapper(final JList list) {
            super(list);
            list.addMouseMotionListener(new MouseMotionAdapter(){
                boolean myIsEngaged = false;

                public void mouseMoved(MouseEvent e) {
                    if (this.myIsEngaged) {
                        Point point = e.getPoint();
                        int index = list.locationToIndex(point);
                        list.setSelectedIndex(index);
                    } else {
                        this.myIsEngaged = true;
                    }
                }
            });
            ListScrollingUtil.installActions(list);
            int modelSize = list.getModel().getSize();
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            if (modelSize > 0 && modelSize <= 20) {
                list.setVisibleRowCount(0);
                this.getViewport().setPreferredSize(list.getPreferredSize());
            } else {
                list.setVisibleRowCount(20);
            }
            this.myList = list;
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            Object selectedValue;
            if (dataId.equals("psi.Element") && (selectedValue = this.myList.getSelectedValue()) instanceof PsiElement) {
                return selectedValue;
            }
            return null;
        }

        public void setBorder(Border border) {
            if (this.myList != null) {
                this.myList.setBorder(border);
            }
        }

        public void requestFocus() {
            this.myList.requestFocus();
        }

        public synchronized void addMouseListener(MouseListener l) {
            this.myList.addMouseListener(l);
        }
    }
}

