/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public final class ShadowAction
implements Disposable {
    private AnAction myAction;
    private AnAction myCopyFromAction;
    private JComponent myComponent;
    private KeymapManagerListener myKeymapManagerListener;
    private ShortcutSet myShortcutSet;
    private String myActionId;
    private Keymap.Listener myKeymapListener;
    private Keymap myKeymap;
    private Presentation myPresentation;
    private UiNotifyConnector myUiNotify;

    public ShadowAction(AnAction action, AnAction copyFromAction, JComponent component, Presentation presentation) {
        this(action, copyFromAction, component);
        this.myPresentation = presentation;
    }

    public ShadowAction(AnAction action, AnAction copyFromAction, JComponent component) {
        this.myAction = action;
        this.myCopyFromAction = copyFromAction;
        this.myComponent = component;
        this.myActionId = ActionManager.getInstance().getId(this.myCopyFromAction);
        this.myKeymapListener = new Keymap.Listener(){

            public void onShortcutChanged(String actionId) {
                if (ShadowAction.this.myActionId == null || actionId.equals(ShadowAction.this.myActionId)) {
                    ShadowAction.this.rebound();
                }
            }
        };
        this.myKeymapManagerListener = new KeymapManagerListener(){

            public void activeKeymapChanged(Keymap keymap) {
                ShadowAction.this.rebound();
            }
        };
        this.myUiNotify = new UiNotifyConnector(this.myComponent, new Activatable(){

            public void showNotify() {
                ShadowAction.this._connect();
            }

            public void hideNotify() {
                ShadowAction.this.disconnect();
            }
        });
    }

    private void _connect() {
        this.disconnect();
        KeymapManager mgr = ShadowAction.getKeymapManager();
        if (mgr == null) {
            return;
        }
        mgr.addKeymapManagerListener(this.myKeymapManagerListener);
        this.rebound();
    }

    private void disconnect() {
        KeymapManager mgr = ShadowAction.getKeymapManager();
        if (mgr == null) {
            return;
        }
        mgr.removeKeymapManagerListener(this.myKeymapManagerListener);
        if (this.myKeymap != null) {
            this.myKeymap.removeShortcutChangeListener(this.myKeymapListener);
        }
    }

    private void rebound() {
        KeymapManager mgr = ShadowAction.getKeymapManager();
        if (mgr == null) {
            return;
        }
        this.myActionId = ActionManager.getInstance().getId(this.myCopyFromAction);
        if (this.myPresentation == null) {
            this.myAction.copyFrom(this.myCopyFromAction);
        } else {
            this.myAction.getTemplatePresentation().copyFrom(this.myPresentation);
            this.myAction.copyShortcutFrom(this.myCopyFromAction);
        }
        this.unregisterAll();
        this.myKeymap = mgr.getActiveKeymap();
        this.myKeymap.addShortcutChangeListener(this.myKeymapListener);
        if (this.myActionId == null) {
            return;
        }
        Shortcut[] shortcuts = this.myKeymap.getShortcuts(this.myActionId);
        this.myShortcutSet = new CustomShortcutSet(shortcuts);
        this.myAction.registerCustomShortcutSet(this.myShortcutSet, this.myComponent);
    }

    private void unregisterAll() {
        if (this.myShortcutSet != null) {
            this.myAction.unregisterCustomShortcutSet(this.myComponent);
        }
        if (this.myKeymap != null) {
            this.myKeymap.removeShortcutChangeListener(this.myKeymapListener);
        }
    }

    public void dispose() {
        this.unregisterAll();
        this.myUiNotify.dispose();
        this.disconnect();
    }

    @Nullable
    private static KeymapManager getKeymapManager() {
        if (ApplicationManager.getApplication().isDisposed()) {
            return null;
        }
        return KeymapManager.getInstance();
    }
}

