/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectFromListDialog
extends DialogWrapper {
    private final ToStringAspect myToStringAspect;
    private final DefaultListModel myModel = new DefaultListModel();
    private final JList myList = new JList(this.myModel);
    private final JPanel myMainPanel = new JPanel(new BorderLayout());
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.ui.SelectFromListDialog");

    public SelectFromListDialog(Project project, Object[] objects, ToStringAspect toStringAspect, String title, int selectionMode) {
        super(project, true);
        this.myToStringAspect = toStringAspect;
        this.myList.setSelectionMode(selectionMode);
        this.setTitle(title);
        for (int i = 0; i < objects.length; ++i) {
            this.myModel.addElement(objects[i]);
        }
        this.myList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                SelectFromListDialog.this.setOKActionEnabled(SelectFromListDialog.this.myList.getSelectedValues().length > 0);
            }
        });
        this.myList.setSelectedIndex(0);
        this.myList.setCellRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                this.append(SelectFromListDialog.this.myToStringAspect.getToStirng(value), new SimpleTextAttributes(0, list.getForeground()));
            }
        });
        this.init();
    }

    protected JComponent createCenterPanel() {
        this.myMainPanel.add((Component)ScrollPaneFactory.createScrollPane(this.myList), "Center");
        return this.myMainPanel;
    }

    public void addToDialog(JComponent userComponent, String borderLayoutConstraints) {
        LOG.assertTrue(borderLayoutConstraints != null);
        LOG.assertTrue(!borderLayoutConstraints.equals("Center"), "Can't add any component to center");
        this.myMainPanel.add((Component)userComponent, borderLayoutConstraints);
    }

    public void setSelection(String defaultLocation) {
        int index = this.myModel.indexOf(defaultLocation);
        if (index >= 0) {
            this.myList.getSelectionModel().setSelectionInterval(index, index);
        }
    }

    public Object[] getSelection() {
        if (!this.isOK()) {
            return null;
        }
        return this.myList.getSelectedValues();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myList;
    }

    public static interface ToStringAspect {
        public String getToStirng(Object var1);
    }
}

