/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.ui.TestDialog;
import com.intellij.openapi.ui.TestInputDialog;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.html.HTMLEditorKit;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class Messages {
    private static TestDialog ourTestImplementation = TestDialog.DEFAULT;
    private static TestInputDialog ourTestInputImplementation = TestInputDialog.DEFAULT;
    private static Logger LOG = Logger.getInstance("#com.intellij.openapi.ui.Messages");
    protected static final String OK_BUTTON = CommonBundle.getOkButtonText();
    protected static final String YES_BUTTON = CommonBundle.getYesButtonText();
    protected static final String NO_BUTTON = CommonBundle.getNoButtonText();
    protected static final String CANCEL_BUTTON = CommonBundle.getCancelButtonText();

    public static TestDialog setTestDialog(TestDialog newValue) {
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            LOG.assertTrue(application.isUnitTestMode(), "This methos is available for tests only");
        }
        TestDialog oldValue = ourTestImplementation;
        ourTestImplementation = newValue;
        return oldValue;
    }

    public static Icon getErrorIcon() {
        return UIUtil.getErrorIcon();
    }

    public static Icon getInformationIcon() {
        return UIUtil.getInformationIcon();
    }

    public static Icon getWarningIcon() {
        return UIUtil.getWarningIcon();
    }

    public static Icon getQuestionIcon() {
        return UIUtil.getQuestionIcon();
    }

    public static int showDialog(Project project, String message, String title, String[] options, int defaultOptionIndex, Icon icon) {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            return ourTestImplementation.show(message);
        }
        MessageDialog dialog = new MessageDialog(project, message, title, options, defaultOptionIndex, icon);
        dialog.show();
        return dialog.getExitCode();
    }

    public static int showDialog(Component parent, String message, String title, String[] options, int defaultOptionIndex, Icon icon) {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            return ourTestImplementation.show(message);
        }
        MessageDialog dialog = new MessageDialog(parent, message, title, options, defaultOptionIndex, icon);
        dialog.show();
        return dialog.getExitCode();
    }

    public static int showDialog(String message, String title, String[] options, int defaultOptionIndex, Icon icon) {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            return ourTestImplementation.show(message);
        }
        MessageDialog dialog = new MessageDialog(message, title, options, defaultOptionIndex, icon);
        dialog.show();
        return dialog.getExitCode();
    }

    public static void showMessageDialog(Project project, String message, String title, Icon icon) {
        Messages.showDialog(project, message, title, new String[]{OK_BUTTON}, 0, icon);
    }

    public static void showMessageDialog(Component parent, String message, String title, Icon icon) {
        Messages.showDialog(parent, message, title, new String[]{OK_BUTTON}, 0, icon);
    }

    public static void showMessageDialog(String message, String title, Icon icon) {
        Messages.showDialog(message, title, new String[]{OK_BUTTON}, 0, icon);
    }

    public static int showYesNoDialog(Project project, String message, String title, Icon icon) {
        return Messages.showDialog(project, message, title, new String[]{YES_BUTTON, NO_BUTTON}, 0, icon);
    }

    public static int showYesNoDialog(Component parent, String message, String title, Icon icon) {
        return Messages.showDialog(parent, message, title, new String[]{YES_BUTTON, NO_BUTTON}, 0, icon);
    }

    public static int showYesNoDialog(String message, String title, Icon icon) {
        return Messages.showDialog(message, title, new String[]{YES_BUTTON, NO_BUTTON}, 0, icon);
    }

    public static int showOkCancelDialog(Project project, String message, String title, Icon icon) {
        return Messages.showDialog(project, message, title, new String[]{OK_BUTTON, CANCEL_BUTTON}, 0, icon);
    }

    public static int showOkCancelDialog(Component parent, String message, String title, Icon icon) {
        return Messages.showDialog(parent, message, title, new String[]{OK_BUTTON, CANCEL_BUTTON}, 0, icon);
    }

    public static int showOkCancelDialog(String message, String title, Icon icon) {
        return Messages.showDialog(message, title, new String[]{OK_BUTTON, CANCEL_BUTTON}, 0, icon);
    }

    public static void showErrorDialog(Project project, String message, String title) {
        Messages.showDialog(project, message, title, new String[]{OK_BUTTON}, 0, Messages.getErrorIcon());
    }

    public static void showErrorDialog(Component component, String message, String title) {
        Messages.showDialog(component, message, title, new String[]{OK_BUTTON}, 0, Messages.getErrorIcon());
    }

    public static void showErrorDialog(Component component, String message) {
        Messages.showDialog(component, message, CommonBundle.getErrorTitle(), new String[]{OK_BUTTON}, 0, Messages.getErrorIcon());
    }

    public static void showErrorDialog(String message, String title) {
        Messages.showDialog(message, title, new String[]{OK_BUTTON}, 0, Messages.getErrorIcon());
    }

    public static void showWarningDialog(Project project, String message, String title) {
        Messages.showDialog(project, message, title, new String[]{OK_BUTTON}, 0, Messages.getWarningIcon());
    }

    public static void showWarningDialog(Component component, String message, String title) {
        Messages.showDialog(component, message, title, new String[]{OK_BUTTON}, 0, Messages.getWarningIcon());
    }

    public static void showWarningDialog(String message, String title) {
        Messages.showDialog(message, title, new String[]{OK_BUTTON}, 0, Messages.getWarningIcon());
    }

    public static int showYesNoCancelDialog(Project project, String message, String title, Icon icon) {
        return Messages.showDialog(project, message, title, new String[]{YES_BUTTON, NO_BUTTON, CANCEL_BUTTON}, 0, icon);
    }

    public static int showYesNoCancelDialog(Component parent, String message, String title, Icon icon) {
        return Messages.showDialog(parent, message, title, new String[]{YES_BUTTON, NO_BUTTON, CANCEL_BUTTON}, 0, icon);
    }

    public static int showYesNoCancelDialog(String message, String title, Icon icon) {
        return Messages.showDialog(message, title, new String[]{YES_BUTTON, NO_BUTTON, CANCEL_BUTTON}, 0, icon);
    }

    @Nullable
    public static String showInputDialog(Project project, String message, String title, Icon icon) {
        return Messages.showInputDialog(project, message, title, icon, null, null);
    }

    @Nullable
    public static String showInputDialog(Component parent, String message, String title, Icon icon) {
        return Messages.showInputDialog(parent, message, title, icon, null, null);
    }

    @Nullable
    public static String showInputDialog(String message, String title, Icon icon) {
        return Messages.showInputDialog(message, title, icon, null, null);
    }

    @Nullable
    public static String showInputDialog(Project project, String message, String title, Icon icon, String initialValue, InputValidator validator) {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            return ourTestInputImplementation.show(message);
        }
        InputDialog dialog = new InputDialog(project, message, title, icon, initialValue, validator);
        dialog.show();
        return dialog.getInputString();
    }

    @Nullable
    public static String showInputDialog(Component parent, String message, String title, Icon icon, String initialValue, InputValidator validator) {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            return ourTestInputImplementation.show(message);
        }
        InputDialog dialog = new InputDialog(parent, message, title, icon, initialValue, validator);
        dialog.show();
        return dialog.getInputString();
    }

    @Nullable
    public static String showInputDialog(String message, String title, Icon icon, String initialValue, InputValidator validator) {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            return ourTestInputImplementation.show(message);
        }
        InputDialog dialog = new InputDialog(message, title, icon, initialValue, validator);
        dialog.show();
        return dialog.getInputString();
    }

    @Nullable
    public static String showEditableChooseDialog(String message, String title, Icon icon, String[] values, String initialValue, InputValidator validator) {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            return ourTestInputImplementation.show(message);
        }
        ChooseDialog dialog = new ChooseDialog(message, title, icon, values, initialValue);
        dialog.setValidator(validator);
        dialog.getComboBox().setEditable(true);
        dialog.getComboBox().getEditor().setItem(initialValue);
        dialog.getComboBox().setSelectedItem(initialValue);
        dialog.show();
        return dialog.getInputString();
    }

    public static int showChooseDialog(String message, String title, String[] values, String initialValue, Icon icon) {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            return ourTestImplementation.show(message);
        }
        ChooseDialog dialog = new ChooseDialog(message, title, icon, values, initialValue);
        dialog.show();
        return dialog.getSelectedIndex();
    }

    public static int showChooseDialog(Component parent, String message, String title, String[] values, String initialValue, Icon icon) {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            return ourTestImplementation.show(message);
        }
        ChooseDialog dialog = new ChooseDialog(parent, message, title, icon, values, initialValue);
        dialog.show();
        return dialog.getSelectedIndex();
    }

    public static int showChooseDialog(Project project, String message, String title, Icon icon, String[] values, String initialValue) {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            return ourTestImplementation.show(message);
        }
        ChooseDialog dialog = new ChooseDialog(project, message, title, icon, values, initialValue);
        dialog.show();
        return dialog.getSelectedIndex();
    }

    public static void showInfoMessage(Component component, String message, String title) {
        Messages.showMessageDialog(component, message, title, Messages.getInformationIcon());
    }

    public static void showInfoMessage(Project project, String message, String title) {
        Messages.showMessageDialog(project, message, title, Messages.getInformationIcon());
    }

    public static void showInfoMessage(String message, String title) {
        Messages.showMessageDialog(message, title, Messages.getInformationIcon());
    }

    public static void showTextAreaDialog(final JTextField textField, String title, @NonNls String dimensionServiceKey) {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            ourTestImplementation.show(title);
        } else {
            final JTextArea textArea = new JTextArea(10, 50);
            textArea.setWrapStyleWord(true);
            textArea.setLineWrap(true);
            textArea.getDocument().addDocumentListener(new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    textField.setText(textArea.getText());
                }
            });
            textArea.setText(textField.getText().replaceAll("[\\ ]*=[\\ ]*", "=").replaceAll(" ", "\n"));
            InsertPathAction.copyFromTo(textField, textArea);
            DialogBuilder builder = new DialogBuilder(textField);
            JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(textArea);
            builder.setDimensionServiceKey(dimensionServiceKey);
            builder.setCenterPanel(scrollPane);
            builder.setPreferedFocusComponent(textArea);
            String rawText = title;
            if (StringUtil.endsWithChar(rawText, ':')) {
                rawText = rawText.substring(0, rawText.length() - 1);
            }
            builder.setTitle(rawText);
            builder.addCloseButton();
            builder.show();
        }
    }

    protected static class ChooseDialog
    extends MessageDialog {
        private ComboBox myComboBox;
        private InputValidator myValidator;

        public ChooseDialog(Project project, String message, String title, Icon icon, String[] values, String initialValue, String[] options, int defaultOption) {
            super(project, message, title, options, defaultOption, icon);
            this.myComboBox.setModel(new DefaultComboBoxModel<String>(values));
            this.myComboBox.setSelectedItem(initialValue);
        }

        public ChooseDialog(Project project, String message, String title, Icon icon, String[] values, String initialValue) {
            this(project, message, title, icon, values, initialValue, new String[]{OK_BUTTON, CANCEL_BUTTON}, 0);
        }

        public ChooseDialog(Component parent, String message, String title, Icon icon, String[] values, String initialValue) {
            super(parent, message, title, new String[]{OK_BUTTON, CANCEL_BUTTON}, 0, icon);
            this.myComboBox.setModel(new DefaultComboBoxModel<String>(values));
            this.myComboBox.setSelectedItem(initialValue);
        }

        public ChooseDialog(String message, String title, Icon icon, String[] values, String initialValue) {
            super(message, title, new String[]{OK_BUTTON, CANCEL_BUTTON}, 0, icon);
            this.myComboBox.setModel(new DefaultComboBoxModel<String>(values));
            this.myComboBox.setSelectedItem(initialValue);
        }

        protected Action[] createActions() {
            final Action[] actions = new Action[this.myOptions.length];
            for (int i = 0; i < this.myOptions.length; ++i) {
                String option = this.myOptions[i];
                final int exitCode = i;
                if (i == this.myDefaultOptionIndex) {
                    actions[i] = new AbstractAction(option){

                        public void actionPerformed(ActionEvent e) {
                            if (ChooseDialog.this.myValidator == null || ChooseDialog.this.myValidator.checkInput(ChooseDialog.this.myComboBox.getSelectedItem().toString().trim())) {
                                ChooseDialog.this.close(exitCode);
                            }
                        }
                    };
                    actions[i].putValue("DefaultAction", Boolean.TRUE);
                    this.myComboBox.addItemListener(new ItemListener(){

                        public void itemStateChanged(ItemEvent e) {
                            actions[exitCode].setEnabled(ChooseDialog.this.myValidator == null || ChooseDialog.this.myValidator.checkInput(ChooseDialog.this.myComboBox.getSelectedItem().toString().trim()));
                        }
                    });
                    final JTextField textField = (JTextField)this.myComboBox.getEditor().getEditorComponent();
                    textField.getDocument().addDocumentListener(new DocumentAdapter(){

                        public void textChanged(DocumentEvent event) {
                            actions[exitCode].setEnabled(ChooseDialog.this.myValidator == null || ChooseDialog.this.myValidator.checkInput(textField.getText().trim()));
                        }
                    });
                    continue;
                }
                actions[i] = new AbstractAction(option){

                    public void actionPerformed(ActionEvent e) {
                        ChooseDialog.this.close(exitCode);
                    }
                };
            }
            return actions;
        }

        protected JComponent createCenterPanel() {
            return null;
        }

        protected JComponent createNorthPanel() {
            JPanel panel = new JPanel(new BorderLayout(15, 0));
            if (this.myIcon != null) {
                JLabel iconLabel = new JLabel(this.myIcon);
                Container container = new Container();
                container.setLayout(new BorderLayout());
                container.add((Component)iconLabel, "North");
                panel.add((Component)container, "West");
            }
            JPanel messagePanel = new JPanel(new BorderLayout());
            if (this.myMessage != null) {
                JLabel textLabel = new JLabel(this.myMessage);
                textLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
                textLabel.setUI(new MultiLineLabelUI());
                messagePanel.add((Component)textLabel, "North");
            }
            this.myComboBox = new ComboBox(220);
            messagePanel.add((Component)this.myComboBox, "South");
            panel.add((Component)messagePanel, "Center");
            return panel;
        }

        protected void doOKAction() {
            String inputString = this.myComboBox.getSelectedItem().toString().trim();
            if (this.myValidator == null || this.myValidator.checkInput(inputString) && this.myValidator.canClose(inputString)) {
                super.doOKAction();
            }
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myComboBox;
        }

        @Nullable
        public String getInputString() {
            if (this.getExitCode() == 0) {
                return this.myComboBox.getSelectedItem().toString();
            }
            return null;
        }

        public int getSelectedIndex() {
            if (this.getExitCode() == 0) {
                return this.myComboBox.getSelectedIndex();
            }
            return -1;
        }

        public JComboBox getComboBox() {
            return this.myComboBox;
        }

        public void setValidator(InputValidator validator) {
            this.myValidator = validator;
        }
    }

    protected static class InputDialog
    extends MessageDialog {
        private JTextField myField;
        private InputValidator myValidator;

        public InputDialog(Project project, String message, String title, Icon icon, String initialValue, InputValidator validator, String[] options, int defaultOption) {
            super(project, message, title, options, defaultOption, icon);
            this.myValidator = validator;
            this.myField.setText(initialValue);
        }

        public InputDialog(Project project, String message, String title, Icon icon, String initialValue, InputValidator validator) {
            this(project, message, title, icon, initialValue, validator, new String[]{OK_BUTTON, CANCEL_BUTTON}, 0);
        }

        public InputDialog(Component parent, String message, String title, Icon icon, String initialValue, InputValidator validator) {
            super(parent, message, title, new String[]{OK_BUTTON, CANCEL_BUTTON}, 0, icon);
            this.myValidator = validator;
            this.myField.setText(initialValue);
        }

        public InputDialog(String message, String title, Icon icon, String initialValue, InputValidator validator) {
            super(message, title, new String[]{OK_BUTTON, CANCEL_BUTTON}, 0, icon);
            this.myValidator = validator;
            this.myField.setText(initialValue);
        }

        protected Action[] createActions() {
            final Action[] actions = new Action[this.myOptions.length];
            for (int i = 0; i < this.myOptions.length; ++i) {
                String option = this.myOptions[i];
                final int exitCode = i;
                if (i == 0) {
                    actions[i] = new AbstractAction(option){

                        public void actionPerformed(ActionEvent e) {
                            String inputString = InputDialog.this.myField.getText().trim();
                            if (InputDialog.this.myValidator == null || InputDialog.this.myValidator.checkInput(inputString) && InputDialog.this.myValidator.canClose(inputString)) {
                                InputDialog.this.close(exitCode);
                            }
                        }
                    };
                    actions[i].putValue("DefaultAction", Boolean.TRUE);
                    this.myField.getDocument().addDocumentListener(new DocumentAdapter(){

                        public void textChanged(DocumentEvent event) {
                            actions[exitCode].setEnabled(InputDialog.this.myValidator == null || InputDialog.this.myValidator.checkInput(InputDialog.this.myField.getText().trim()));
                        }
                    });
                    continue;
                }
                actions[i] = new AbstractAction(option){

                    public void actionPerformed(ActionEvent e) {
                        InputDialog.this.close(exitCode);
                    }
                };
            }
            return actions;
        }

        protected JComponent createCenterPanel() {
            return null;
        }

        protected JComponent createNorthPanel() {
            JPanel panel = new JPanel(new BorderLayout(15, 0));
            if (this.myIcon != null) {
                JLabel iconLabel = new JLabel(this.myIcon);
                Container container = new Container();
                container.setLayout(new BorderLayout());
                container.add((Component)iconLabel, "North");
                panel.add((Component)container, "West");
            }
            JPanel messagePanel = new JPanel(new BorderLayout());
            if (this.myMessage != null) {
                JLabel textLabel = new JLabel(this.myMessage);
                textLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
                textLabel.setUI(new MultiLineLabelUI());
                messagePanel.add((Component)textLabel, "North");
            }
            this.myField = new JTextField(30);
            messagePanel.add((Component)this.myField, "South");
            panel.add((Component)messagePanel, "Center");
            return panel;
        }

        public JTextField getTextField() {
            return this.myField;
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myField;
        }

        @Nullable
        public String getInputString() {
            if (this.getExitCode() == 0) {
                return this.myField.getText().trim();
            }
            return null;
        }
    }

    private static class MessageDialog
    extends DialogWrapper {
        protected String myMessage;
        protected String[] myOptions;
        protected int myDefaultOptionIndex;
        protected Icon myIcon;

        public MessageDialog(Project project, String message, String title, String[] options, int defaultOptionIndex, Icon icon) {
            super(project, false);
            this._init(title, message, options, defaultOptionIndex, icon);
        }

        public MessageDialog(Component parent, String message, String title, String[] options, int defaultOptionIndex, Icon icon) {
            super(parent, false);
            this._init(title, message, options, defaultOptionIndex, icon);
        }

        public MessageDialog(String message, String title, String[] options, int defaultOptionIndex, Icon icon) {
            super(false);
            this._init(title, message, options, defaultOptionIndex, icon);
        }

        private void _init(String title, String message, String[] options, int defaultOptionIndex, Icon icon) {
            this.setTitle(title);
            this.myMessage = message;
            this.myOptions = options;
            this.myDefaultOptionIndex = defaultOptionIndex;
            this.myIcon = icon;
            this.setButtonsAlignment(0);
            this.init();
        }

        protected Action[] createActions() {
            Action[] actions = new Action[this.myOptions.length];
            for (int i = 0; i < this.myOptions.length; ++i) {
                String option = this.myOptions[i];
                final int exitCode = i;
                actions[i] = new AbstractAction(option){

                    public void actionPerformed(ActionEvent e) {
                        MessageDialog.this.close(exitCode);
                    }
                };
                if (i == this.myDefaultOptionIndex) {
                    actions[i].putValue("DefaultAction", Boolean.TRUE);
                }
                this.assignMnemonic(option, actions[i]);
            }
            return actions;
        }

        private void assignMnemonic(String option, Action action) {
            String mnemoChar;
            int mnemoPos = option.indexOf("&");
            if (mnemoPos >= 0 && mnemoPos < option.length() - 2 && (mnemoChar = option.substring(mnemoPos + 1, mnemoPos + 2).trim()).length() == 1) {
                action.putValue("MnemonicKey", new Integer(mnemoChar.charAt(0)));
            }
        }

        public void doCancelAction() {
            this.close(-1);
        }

        protected JComponent createNorthPanel() {
            return null;
        }

        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel(new BorderLayout(15, 0));
            if (this.myIcon != null) {
                JLabel iconLabel = new JLabel(this.myIcon);
                Container container = new Container();
                container.setLayout(new BorderLayout());
                container.add((Component)iconLabel, "North");
                panel.add((Component)container, "West");
            }
            if (this.myMessage != null) {
                JLabel label = new JLabel();
                final JTextPane messageComponent = new JTextPane();
                messageComponent.setFont(label.getFont());
                if (BasicHTML.isHTMLString(this.myMessage)) {
                    HTMLEditorKit editorKit = new HTMLEditorKit();
                    editorKit.getStyleSheet().addRule(UIUtil.displayPropertiesToCSS(label.getFont(), label.getForeground()));
                    messageComponent.setEditorKit(editorKit);
                    messageComponent.setContentType("text/html");
                }
                messageComponent.setText(this.myMessage);
                messageComponent.setEditable(false);
                messageComponent.setCaretPosition(0);
                messageComponent.setBackground(UIUtil.getOptionPaneBackground());
                messageComponent.setForeground(label.getForeground());
                final Dimension screenSize = messageComponent.getToolkit().getScreenSize();
                Dimension textSize = messageComponent.getPreferredSize();
                if (textSize.width > screenSize.width * 4 / 5 || textSize.height > screenSize.height / 2) {
                    final JScrollPane pane = ScrollPaneFactory.createScrollPane(messageComponent);
                    pane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                    pane.setVerticalScrollBarPolicy(20);
                    pane.setHorizontalScrollBarPolicy(30);
                    final int scrollSize = (int)new JScrollBar(1).getPreferredSize().getWidth();
                    Dimension preferredSize = new Dimension(Math.min(textSize.width, screenSize.width * 4 / 5) + scrollSize, Math.min(textSize.height, screenSize.height / 2) + scrollSize);
                    pane.setPreferredSize(preferredSize);
                    panel.add((Component)pane, "Center");
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Dimension textSize = messageComponent.getPreferredSize();
                            Dimension preferredSize = new Dimension(Math.min(textSize.width, screenSize.width * 4 / 5) + scrollSize, Math.min(textSize.height, screenSize.height / 2) + scrollSize);
                            pane.setPreferredSize(preferredSize);
                            SwingUtilities.getWindowAncestor(pane).pack();
                        }
                    });
                } else {
                    panel.add((Component)messageComponent, "Center");
                }
            }
            return panel;
        }
    }
}

