/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.CommonBundle;
import com.intellij.ide.ui.SplitterProportionsDataImpl;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.DetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.IconLoader;
import com.intellij.profile.Profile;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.MultiLineTooltipUI;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.util.Icons;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.Tree;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MasterDetailsComponent
implements Configurable,
PersistentStateComponent<UIState>,
DetailsComponent.Facade {
    protected static final Logger LOG = Logger.getInstance("#com.intellij.openapi.ui.MasterDetailsComponent");
    protected static final Icon COPY_ICON = IconLoader.getIcon("/actions/copy.png");
    protected NamedConfigurable myCurrentConfigurable;
    private Splitter mySplitter;
    @NonNls
    public static final String TREE_OBJECT = "treeObject";
    @NonNls
    public static final String TREE_NAME = "treeName";
    protected History myHistory = new History(new Place.Navigator(){

        public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
            return null;
        }

        public void queryPlace(@NotNull Place place) {
            if (place == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/ui/MasterDetailsComponent$1.queryPlace must not be null");
            }
        }
    });
    protected UIState myState = new UIState();
    protected Runnable TREE_UPDATER = new Runnable(){

        public void run() {
            MyNode node = (MyNode)MasterDetailsComponent.this.myTree.getSelectionPath().getLastPathComponent();
            if (node != null) {
                MasterDetailsComponent.this.myState.lastEditedConfigurable = node.getDisplayName();
                MasterDetailsComponent.this.myDetails.setText(node.getConfigurable().getBannerSlogan());
                ((DefaultTreeModel)MasterDetailsComponent.this.myTree.getModel()).reload(node);
                MasterDetailsComponent.this.fireItemsChangedExternally();
            }
        }
    };
    protected MyNode myRoot = new MyRootNode();
    protected Tree myTree = new Tree();
    private DetailsComponent myDetails = new DetailsComponent();
    protected JPanel myWholePanel;
    public JPanel myNorthPanel = new JPanel(new BorderLayout());
    private ArrayList<ItemsChangeListener> myListners = new ArrayList();
    private Set<NamedConfigurable> myInitializedConfigurables = new HashSet<NamedConfigurable>();
    private boolean myHasDeletedItems;
    protected AutoScrollToSourceHandler myAutoScrollHandler;

    public void setHistory(History history) {
        this.myHistory = history;
    }

    protected MasterDetailsComponent() {
        this.myWholePanel = new JPanel(new BorderLayout()){

            public void addNotify() {
                super.addNotify();
                MasterDetailsComponent.this.addNotify();
            }
        };
        this.mySplitter = new Splitter(false, 0.2f);
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.myWholePanel.add((Component)this.mySplitter, "Center");
        JPanel left = new JPanel(new BorderLayout()){

            public Dimension getMinimumSize() {
                Dimension original = super.getMinimumSize();
                return new Dimension(Math.max(original.width, 100), original.height);
            }
        };
        left.add((Component)this.myNorthPanel, "North");
        left.add((Component)new JScrollPane(this.myTree), "Center");
        this.mySplitter.setFirstComponent(left);
        JPanel right = new JPanel(new BorderLayout());
        right.add((Component)this.myDetails.getComponent(), "Center");
        this.mySplitter.setSecondComponent(right);
        this.myAutoScrollHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return MasterDetailsComponent.this.isAutoScrollEnabled();
            }

            protected void setAutoScrollMode(boolean state) {
            }

            protected void scrollToSource(Component tree) {
                MasterDetailsComponent.this.updateSelectionFromTree();
            }

            protected boolean needToCheckFocus() {
                return false;
            }
        };
        this.myAutoScrollHandler.install(this.myTree);
        GuiUtils.replaceJSplitPaneWithIDEASplitter(this.myWholePanel);
    }

    protected void addNotify() {
        this.updateSelectionFromTree();
    }

    private void updateSelectionFromTree() {
        TreePath path = this.myTree.getSelectionPath();
        if (path != null) {
            Object lastPathComp = path.getLastPathComponent();
            if (!(lastPathComp instanceof MyNode)) {
                return;
            }
            MyNode node = (MyNode)lastPathComp;
            NamedConfigurable configurable = node.getConfigurable();
            this.updateSelection(configurable);
        } else {
            this.updateSelection(null);
        }
    }

    @Override
    public DetailsComponent getDetailsComponent() {
        return this.myDetails;
    }

    public Splitter getSplitter() {
        return this.mySplitter;
    }

    protected boolean isAutoScrollEnabled() {
        return this.myHistory != null ? !this.myHistory.isNavigatingNow() : true;
    }

    private void initToolbar() {
        ArrayList<AnAction> actions = this.createActions(false);
        if (actions != null) {
            DefaultActionGroup group = new DefaultActionGroup();
            for (AnAction action : actions) {
                if (action instanceof ActionGroupWithPreselection) {
                    group.add(new MyActionGroupWrapper((ActionGroupWithPreselection)((Object)action)));
                    continue;
                }
                group.add(action);
            }
            JComponent component = ActionManager.getInstance().createActionToolbar("unknown", group, true).getComponent();
            this.myNorthPanel.add((Component)component, "North");
        }
    }

    protected void addItemsChangeListener(ItemsChangeListener l) {
        this.myListners.add(l);
    }

    @Override
    public JComponent createComponent() {
        SwingUtilities.updateComponentTreeUI(this.myWholePanel);
        JPanel panel = new JPanel(new BorderLayout()){

            public Dimension getPreferredSize() {
                return new Dimension(800, 600);
            }
        };
        panel.add((Component)this.myWholePanel, "Center");
        return panel;
    }

    @Override
    public boolean isModified() {
        if (this.myHasDeletedItems) {
            return true;
        }
        final boolean[] modified = new boolean[1];
        TreeUtil.traverseDepth(this.myRoot, new TreeUtil.Traverse(){

            public boolean accept(Object node) {
                NamedConfigurable configurable;
                if (node instanceof MyNode && MasterDetailsComponent.this.isInitialized(configurable = ((MyNode)node).getConfigurable()) && configurable.isModified()) {
                    modified[0] = true;
                    return false;
                }
                return true;
            }
        });
        return modified[0];
    }

    protected boolean isInitialized(NamedConfigurable configurable) {
        return this.myInitializedConfigurables.contains(configurable);
    }

    @Override
    public void apply() throws ConfigurationException {
        this.processRemovedItems();
        final ConfigurationException[] ex = new ConfigurationException[1];
        TreeUtil.traverse(this.myRoot, new TreeUtil.Traverse(){

            public boolean accept(Object node) {
                if (node instanceof MyNode) {
                    try {
                        NamedConfigurable configurable = ((MyNode)node).getConfigurable();
                        if (MasterDetailsComponent.this.isInitialized(configurable) && configurable.isModified()) {
                            configurable.apply();
                        }
                    }
                    catch (ConfigurationException e) {
                        ex[0] = e;
                        return false;
                    }
                }
                return true;
            }
        });
        if (ex[0] != null) {
            throw ex[0];
        }
        this.myHasDeletedItems = false;
    }

    protected abstract void processRemovedItems();

    protected abstract boolean wasObjectStored(Object var1);

    @Override
    public void reset() {
        this.myHasDeletedItems = false;
        ((DefaultTreeModel)this.myTree.getModel()).reload();
        this.myTree.requestFocus();
        this.myState.proportions.restoreSplitterProportions(this.myWholePanel);
        Enumeration<TreeNode> enumeration = this.myRoot.breadthFirstEnumeration();
        boolean selected = false;
        while (enumeration.hasMoreElements()) {
            Object userObject;
            MyNode node = (MyNode)enumeration.nextElement();
            if (node instanceof MyRootNode || !((userObject = node.getUserObject()) instanceof Configurable)) continue;
            Configurable configurable = (Configurable)userObject;
            String displayName = configurable.getDisplayName();
            this.myState.order.add(displayName);
            if (selected || !Comparing.strEqual(displayName, this.myState.lastEditedConfigurable)) continue;
            TreeUtil.selectInTree(node, true, this.myTree);
            selected = true;
        }
        if (!selected) {
            TreeUtil.selectFirstNode(this.myTree);
        }
    }

    @Override
    public UIState getState() {
        return this.myState;
    }

    @Override
    public void loadState(UIState object) {
        this.myState.lastEditedConfigurable = object.lastEditedConfigurable;
        this.myState.proportions = object.proportions;
        this.myState.order = object.order;
    }

    @Override
    public void disposeUIResources() {
        this.myState.proportions.saveSplitterProportions(this.myWholePanel);
        this.myAutoScrollHandler.cancelAllRequests();
        this.myDetails.disposeUIResources();
        this.myInitializedConfigurables.clear();
        TreeUtil.traverseDepth(this.myRoot, new TreeUtil.Traverse(){

            public boolean accept(Object node) {
                if (node instanceof MyNode) {
                    MyNode treeNode = (MyNode)node;
                    treeNode.getConfigurable().disposeUIResources();
                    if (!(treeNode instanceof MyRootNode)) {
                        treeNode.setUserObject(null);
                    }
                }
                return true;
            }
        });
        this.myRoot.removeAllChildren();
        this.myCurrentConfigurable = null;
    }

    @Nullable
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        return null;
    }

    protected void initTree() {
        ((DefaultTreeModel)this.myTree.getModel()).setRoot(this.myRoot);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        UIUtil.setLineStyleAngled(this.myTree);
        TreeUtil.installActions(this.myTree);
        this.myTree.setCellRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof MyNode) {
                    MyNode node = (MyNode)value;
                    this.setIcon(node.getConfigurable().getIcon(expanded));
                    Font font = UIUtil.getTreeFont();
                    if (node.isDisplayInBold()) {
                        this.setFont(font.deriveFont(1));
                    } else {
                        this.setFont(font.deriveFont(0));
                    }
                    this.append(node.getDisplayName(), node.isDisplayInBold() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }
        });
        this.initToolbar();
        ArrayList<AnAction> actions = this.createActions(true);
        if (actions != null) {
            DefaultActionGroup group = new DefaultActionGroup();
            for (AnAction action : actions) {
                group.add(action);
            }
            actions = this.getAdditionalActions();
            if (actions != null) {
                group.addSeparator();
                for (AnAction action : actions) {
                    group.add(action);
                }
            }
            PopupHandler.installPopupHandler(this.myTree, group, "unknown", ActionManager.getInstance());
        }
    }

    @Nullable
    protected ArrayList<AnAction> getAdditionalActions() {
        return null;
    }

    public void fireItemsChangeListener(Object editableObject) {
        for (ItemsChangeListener listner : this.myListners) {
            listner.itemChanged(editableObject);
        }
    }

    private void fireItemsChangedExternally() {
        for (ItemsChangeListener listner : this.myListners) {
            listner.itemsExternallyChanged();
        }
    }

    private void createUIComponents() {
        this.myTree = new Tree(){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension size = super.getPreferredScrollableViewportSize();
                size = new Dimension(size.width + 20, size.height);
                return size;
            }

            public JToolTip createToolTip() {
                JToolTip toolTip = new JToolTip(){
                    {
                        this.setUI(new MultiLineTooltipUI());
                    }
                };
                toolTip.setComponent(this);
                return toolTip;
            }
        };
    }

    protected void addNode(MyNode nodeToAdd, MyNode parent) {
        parent.add(nodeToAdd);
        TreeUtil.sort(parent, new Comparator(){

            public int compare(Object o1, Object o2) {
                MyNode node1 = (MyNode)o1;
                MyNode node2 = (MyNode)o2;
                return node1.getDisplayName().compareToIgnoreCase(node2.getDisplayName());
            }
        });
        ((DefaultTreeModel)this.myTree.getModel()).reload(parent);
    }

    public ActionCallback selectNodeInTree(DefaultMutableTreeNode nodeToSelect) {
        return this.selectNodeInTree(nodeToSelect, true);
    }

    public ActionCallback selectNodeInTree(DefaultMutableTreeNode nodeToSelect, boolean center) {
        this.myTree.requestFocus();
        if (nodeToSelect != null) {
            return TreeUtil.selectInTree(nodeToSelect, true, this.myTree, center);
        }
        return TreeUtil.selectFirstNode(this.myTree);
    }

    @Nullable
    public Object getSelectedObject() {
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath != null && selectionPath.getLastPathComponent() instanceof MyNode) {
            MyNode node = (MyNode)selectionPath.getLastPathComponent();
            NamedConfigurable configurable = node.getConfigurable();
            LOG.assertTrue(configurable != null, "already disposed");
            return configurable.getEditableObject();
        }
        return null;
    }

    @Nullable
    public NamedConfigurable getSelectedConfugurable() {
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath != null) {
            MyNode node = (MyNode)selectionPath.getLastPathComponent();
            NamedConfigurable configurable = node.getConfigurable();
            LOG.assertTrue(configurable != null, "already disposed");
            return configurable;
        }
        return null;
    }

    public void selectNodeInTree(String displayName) {
        MyNode nodeByName = MasterDetailsComponent.findNodeByName(this.myRoot, displayName);
        this.selectNodeInTree(nodeByName);
    }

    public void selectNodeInTree(Object object) {
        this.selectNodeInTree(MasterDetailsComponent.findNodeByObject(this.myRoot, object));
    }

    @Nullable
    protected static MyNode findNodeByName(TreeNode root, final String profileName) {
        if (profileName == null) {
            return null;
        }
        return MasterDetailsComponent.findNodeByCondition(root, new Condition<NamedConfigurable>(){

            @Override
            public boolean value(NamedConfigurable configurable) {
                return Comparing.strEqual(profileName, configurable.getDisplayName());
            }
        });
    }

    @Nullable
    public static MyNode findNodeByObject(TreeNode root, final Object editableObject) {
        if (editableObject == null) {
            return null;
        }
        return MasterDetailsComponent.findNodeByCondition(root, new Condition<NamedConfigurable>(){

            @Override
            public boolean value(NamedConfigurable configurable) {
                return Comparing.equal(editableObject, configurable.getEditableObject());
            }
        });
    }

    protected static MyNode findNodeByCondition(TreeNode root, final Condition<NamedConfigurable> condition) {
        final MyNode[] nodeToSelect = new MyNode[1];
        TreeUtil.traverseDepth(root, new TreeUtil.Traverse(){

            public boolean accept(Object node) {
                if (condition.value(((MyNode)node).getConfigurable())) {
                    nodeToSelect[0] = (MyNode)node;
                    return false;
                }
                return true;
            }
        });
        return nodeToSelect[0];
    }

    protected void updateSelection(@Nullable NamedConfigurable configurable) {
        if (configurable != null) {
            this.myState.lastEditedConfigurable = configurable.getDisplayName();
        }
        this.myDetails.setText(configurable != null ? configurable.getBannerSlogan() : null);
        this.myCurrentConfigurable = configurable;
        if (configurable != null) {
            this.myDetails.setContent(configurable.createComponent());
            if (!this.isInitialized(configurable)) {
                configurable.reset();
                this.initializeConfigurable(configurable);
            }
            this.myHistory.pushPlaceForElement(TREE_OBJECT, configurable.getEditableObject());
        } else {
            this.myDetails.setContent(null);
            this.myDetails.setEmptyContentText(this.getEmptySelectionString());
        }
    }

    @Nullable
    protected String getEmptySelectionString() {
        return null;
    }

    protected void initializeConfigurable(NamedConfigurable configurable) {
        this.myInitializedConfigurables.add(configurable);
    }

    protected void checkApply(Set<MyNode> rootNodes, String prefix, String title) throws ConfigurationException {
        MyNode rootNode;
        String alreadyExist = null;
        Iterator<MyNode> i$ = rootNodes.iterator();
        while (i$.hasNext() && (alreadyExist = MasterDetailsComponent.alreadyExist(rootNode = i$.next())) == null) {
        }
        if (alreadyExist != null) {
            Object o = this.getSelectedObject();
            if (o instanceof NamedScope && !Comparing.strEqual(alreadyExist, ((NamedScope)o).getName())) {
                this.selectNodeInTree(alreadyExist);
            }
            throw new ConfigurationException(CommonBundle.message("smth.already.exist.error.message", prefix, alreadyExist), title);
        }
    }

    @Nullable
    private static String alreadyExist(MyNode root) {
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < root.getChildCount(); ++i) {
            NamedConfigurable scopeConfigurable = ((MyNode)root.getChildAt(i)).getConfigurable();
            String name = scopeConfigurable.getDisplayName();
            if (names.contains(name)) {
                return name;
            }
            names.add(name);
        }
        return null;
    }

    public Tree getTree() {
        return this.myTree;
    }

    protected class MyActionGroupWrapper
    extends AnAction {
        private ActionGroup myActionGroup;
        private ActionGroupWithPreselection myPreselection;

        public MyActionGroupWrapper(ActionGroupWithPreselection actionGroup) {
            this(actionGroup.getActionGroup());
            this.myPreselection = actionGroup;
        }

        public MyActionGroupWrapper(ActionGroup actionGroup) {
            super(actionGroup.getTemplatePresentation().getText(), actionGroup.getTemplatePresentation().getDescription(), actionGroup.getTemplatePresentation().getIcon());
            this.myActionGroup = actionGroup;
            this.registerCustomShortcutSet(actionGroup.getShortcutSet(), MasterDetailsComponent.this.myTree);
        }

        public void actionPerformed(AnActionEvent e) {
            JBPopupFactory popupFactory = JBPopupFactory.getInstance();
            ListPopupStep step = popupFactory.createActionsStep(this.myActionGroup, e.getDataContext(), false, false, this.myActionGroup.getTemplatePresentation().getText(), MasterDetailsComponent.this.myTree, true, this.myPreselection != null ? this.myPreselection.getDefaultIndex() : 0, true);
            ListPopup listPopup = popupFactory.createListPopup(step);
            listPopup.setHandleAutoSelectionBeforeShow(true);
            listPopup.showUnderneathOf(MasterDetailsComponent.this.myNorthPanel);
        }
    }

    public static interface ActionGroupWithPreselection {
        public ActionGroup getActionGroup();

        public int getDefaultIndex();
    }

    protected static interface ItemsChangeListener {
        public void itemChanged(@Nullable Object var1);

        public void itemsExternallyChanged();
    }

    private static class MyRootNode
    extends MyNode {
        public MyRootNode() {
            super(new NamedConfigurable(false, null){

                public void setDisplayName(String name) {
                }

                public Object getEditableObject() {
                    return null;
                }

                public String getBannerSlogan() {
                    return null;
                }

                public String getDisplayName() {
                    return "";
                }

                public Icon getIcon() {
                    return Profile.LOCAL_PROFILE;
                }

                @Nullable
                @NonNls
                public String getHelpTopic() {
                    return null;
                }

                public JComponent createOptionsPanel() {
                    return null;
                }

                public boolean isModified() {
                    return false;
                }

                public void apply() throws ConfigurationException {
                }

                public void reset() {
                }

                public void disposeUIResources() {
                }
            }, false);
        }
    }

    public static class MyNode
    extends DefaultMutableTreeNode {
        private boolean myDisplayInBold;

        public MyNode(NamedConfigurable userObject) {
            super(userObject);
        }

        public MyNode(NamedConfigurable userObject, boolean displayInBold) {
            super(userObject);
            this.myDisplayInBold = displayInBold;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public String getDisplayName() {
            NamedConfigurable configurable = (NamedConfigurable)this.getUserObject();
            LOG.assertTrue(configurable != null, "Tree was already disposed");
            String string = configurable.getDisplayName();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/ui/MasterDetailsComponent$MyNode.getDisplayName must not return null");
            }
            return string;
        }

        public NamedConfigurable getConfigurable() {
            return (NamedConfigurable)this.getUserObject();
        }

        public boolean isDisplayInBold() {
            return this.myDisplayInBold;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MyDeleteAction
    extends AnAction {
        private Condition<Object> myCondition;

        public MyDeleteAction(Condition<Object> availableCondition) {
            super(CommonBundle.message("button.delete", new Object[0]), CommonBundle.message("button.delete", new Object[0]), Icons.DELETE_ICON);
            this.registerCustomShortcutSet(CommonShortcuts.DELETE, MasterDetailsComponent.this.myTree);
            this.myCondition = availableCondition;
        }

        @Override
        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(false);
            TreePath[] selectionPath = MasterDetailsComponent.this.myTree.getSelectionPaths();
            if (selectionPath != null) {
                for (TreePath path : selectionPath) {
                    if (this.myCondition.value(path.getLastPathComponent())) continue;
                    return;
                }
                presentation.setEnabled(true);
            }
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            this.removePaths(MasterDetailsComponent.this.myTree.getSelectionPaths());
        }

        protected void removePaths(TreePath[] paths) {
            DefaultMutableTreeNode parentNode = null;
            int idx = -1;
            for (TreePath path : paths) {
                MyNode node = (MyNode)path.getLastPathComponent();
                NamedConfigurable namedConfigurable = node.getConfigurable();
                Object editableObject = namedConfigurable.getEditableObject();
                parentNode = (MyNode)node.getParent();
                idx = parentNode.getIndex(node);
                parentNode.remove(node);
                MasterDetailsComponent.this.myHasDeletedItems = (byte)(MasterDetailsComponent.this.myHasDeletedItems | (MasterDetailsComponent.this.wasObjectStored(editableObject) ? 1 : 0));
                MasterDetailsComponent.this.fireItemsChangeListener(editableObject);
                namedConfigurable.disposeUIResources();
            }
            ((DefaultTreeModel)MasterDetailsComponent.this.myTree.getModel()).reload();
            if (parentNode != null && idx != -1) {
                TreeUtil.selectInTree((DefaultMutableTreeNode)(idx < parentNode.getChildCount() ? parentNode.getChildAt(idx) : parentNode), true, MasterDetailsComponent.this.myTree);
            } else {
                TreeUtil.selectFirstNode(MasterDetailsComponent.this.myTree);
            }
        }
    }

    public static class UIState {
        public SplitterProportionsDataImpl proportions = new SplitterProportionsDataImpl();
        public String lastEditedConfigurable;
        public List<String> order = new ArrayList<String>();
    }
}

