/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class FixedSizeButton
extends JButton {
    private final int mySize;
    private JComponent myComponent;

    public FixedSizeButton() {
        this(-1, null);
    }

    private FixedSizeButton(int size, JComponent component) {
        super(IconLoader.getIcon("/general/ellipsis.png"));
        this.mySize = size;
        this.myComponent = component;
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setDefaultCapable(false);
        this.setFocusable(false);
        if (SystemInfo.isMac) {
            this.putClientProperty("JButton.buttonType", "square");
        }
    }

    public FixedSizeButton(int size) {
        this(size, null);
        if (size <= 0) {
            throw new IllegalArgumentException("wrong size: " + size);
        }
    }

    public FixedSizeButton(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/ui/FixedSizeButton.<init> must not be null");
        }
        this(-1, component);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        if (this.myComponent != null) {
            int size = this.myComponent.getPreferredSize().height;
            return new Dimension(size, size);
        }
        if (this.mySize != -1) {
            return new Dimension(this.mySize, this.mySize);
        }
        return super.getPreferredSize();
    }

    public void setAttachedComponent(JComponent component) {
        this.myComponent = component;
    }

    public JComponent getAttachedComponent() {
        return this.myComponent;
    }
}

