/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.peer.PeerFactory;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.popup.StackingPopupDispatcher;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.AwtVisitor;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DialogWrapper {
    public static final int OK_EXIT_CODE = 0;
    public static final int CANCEL_EXIT_CODE = 1;
    public static final int NEXT_USER_EXIT_CODE = 2;
    @NonNls
    public static final String DEFAULT_ACTION = "DefaultAction";
    private final DialogWrapperPeer myPeer;
    private int myExitCode = 1;
    public static final Border ourDefaultBorder = BorderFactory.createEmptyBorder(8, 8, 8, 8);
    private float myHorizontalStretch = 1.0f;
    private float myVerticalStretch = 1.0f;
    private int myButtonAlignment = 4;
    private boolean myCrossClosesWindow = true;
    private Insets myButtonMargins = new Insets(2, 16, 2, 16);
    private Action myOKAction;
    private Action myCancelAction;
    private Action myHelpAction;
    private Component[] myButtons;
    private boolean myClosed = false;
    protected boolean myPerformAction = false;
    private static final Object ourLock = new Object();
    private Action myYesAction = null;
    private Action myNoAction = null;
    protected final Disposable myDisposable = new Disposable(){

        public String toString() {
            return DialogWrapper.this.toString();
        }

        public void dispose() {
            DialogWrapper.this.dispose();
        }
    };
    private ErrorText myErrorText;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DialogWrapper(Project project, boolean canBeParent) {
        Object object = ourLock;
        synchronized (object) {
            this.myPeer = PeerFactory.getInstance().getDialogWrapperPeerFactory().createPeer(this, project, canBeParent);
            this.createDefaultActions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DialogWrapper(boolean canBeParent) {
        Object object = ourLock;
        synchronized (object) {
            this.myPeer = PeerFactory.getInstance().getDialogWrapperPeerFactory().createPeer(this, canBeParent);
            this.createDefaultActions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DialogWrapper(Component parent, boolean canBeParent) {
        Object object = ourLock;
        synchronized (object) {
            this.myPeer = PeerFactory.getInstance().getDialogWrapperPeerFactory().createPeer(this, parent, canBeParent);
            this.createDefaultActions();
        }
    }

    protected void createDefaultActions() {
        this.myOKAction = new OkAction();
        this.myCancelAction = new CancelAction();
        this.myHelpAction = new HelpAction();
    }

    public void setUndecorated(boolean undecorated) {
        this.myPeer.setUndecorated(undecorated);
    }

    public final void addMouseListener(MouseListener listener) {
        this.myPeer.addMouseListener(listener);
    }

    public final void addMouseListener(MouseMotionListener listener) {
        this.myPeer.addMouseListener(listener);
    }

    public final void addKeyListener(KeyListener listener) {
        this.myPeer.addKeyListener(listener);
    }

    public final void close(int exitCode) {
        if (this.myClosed) {
            return;
        }
        this.myClosed = true;
        this.myExitCode = exitCode;
        Disposer.dispose(this.myDisposable);
    }

    @Nullable
    protected Border createContentPaneBorder() {
        return ourDefaultBorder;
    }

    @Nullable
    protected JComponent createSouthPanel() {
        Insets insets;
        Action[] actions = this.createActions();
        Action[] leftSideActions = this.createLeftSideActions();
        ArrayList<Component> buttons = new ArrayList<Component>();
        boolean hasHelpToMoveToLeftSide = false;
        if (SystemInfo.isMacOSLeopard && Arrays.asList(actions).contains(this.getHelpAction())) {
            hasHelpToMoveToLeftSide = true;
            actions = ArrayUtil.remove(actions, this.getHelpAction());
        }
        JPanel panel = new JPanel(new BorderLayout());
        JPanel lrButtonsPanel = new JPanel(new GridBagLayout());
        Insets insets2 = insets = SystemInfo.isMacOSLeopard ? new Insets(0, 0, 0, 0) : new Insets(8, 0, 0, 0);
        if (actions.length > 0 || leftSideActions.length > 0) {
            JPanel buttonsPanel;
            int gridx = 0;
            if (leftSideActions.length > 0) {
                buttonsPanel = this.createButtons(leftSideActions, buttons);
                lrButtonsPanel.add((Component)buttonsPanel, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
            }
            lrButtonsPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 10, 2, insets, 0, 0));
            if (actions.length > 0) {
                buttonsPanel = this.createButtons(actions, buttons);
                lrButtonsPanel.add((Component)buttonsPanel, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
            }
            if (0 == this.myButtonAlignment) {
                lrButtonsPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(gridx, 0, 1, 1, 1.0, 0.0, 10, 2, insets, 0, 0));
            }
            this.myButtons = buttons.toArray(new Component[buttons.size()]);
        }
        if (hasHelpToMoveToLeftSide) {
            JButton helpButton = new JButton(this.getHelpAction());
            helpButton.putClientProperty("JButton.buttonType", "help");
            helpButton.setText("");
            helpButton.setMargin(insets);
            panel.add((Component)helpButton, "West");
        }
        panel.add((Component)lrButtonsPanel, "Center");
        panel.setBorder(IdeBorderFactory.createEmptyBorder(new Insets(8, 0, 0, 0)));
        return panel;
    }

    private JPanel createButtons(Action[] actions, ArrayList<Component> buttons) {
        JPanel buttonsPanel = new JPanel(new GridLayout(1, actions.length, SystemInfo.isMacOSLeopard ? 0 : 5, 0));
        for (Action action : actions) {
            JButton button = this.createJButtonForAction(action);
            Object value = action.getValue("MnemonicKey");
            if (value instanceof Integer) {
                int mnemonic = (Integer)value;
                if (mnemonic == 89) {
                    this.myYesAction = action;
                } else if (mnemonic == 78) {
                    this.myNoAction = action;
                }
                button.setMnemonic(mnemonic);
            }
            buttons.add(button);
            buttonsPanel.add(button);
        }
        return buttonsPanel;
    }

    protected JButton createJButtonForAction(Action action) {
        JButton button = new JButton(action);
        String text = button.getText();
        if (SystemInfo.isMac) {
            button.putClientProperty("JButton.buttonType", "text");
        }
        if (text != null) {
            int mnemonic = 0;
            StringBuilder plainText = new StringBuilder();
            for (int i = 0; i < text.length(); ++i) {
                int ch = text.charAt(i);
                if (ch == 95 || ch == 38) {
                    if (++i >= text.length()) break;
                    ch = text.charAt(i);
                    if (ch != 95 && ch != 38) {
                        int vk = ch;
                        if (vk >= 97 && vk <= 122) {
                            vk -= 32;
                        }
                        mnemonic = vk;
                    }
                }
                plainText.append((char)ch);
            }
            button.setText(plainText.toString());
            if (mnemonic == 89) {
                this.myYesAction = action;
            } else if (mnemonic == 78) {
                this.myNoAction = action;
            }
            button.setMnemonic(mnemonic);
        }
        this.setMargin(button);
        if (action.getValue(DEFAULT_ACTION) != null) {
            this.getRootPane().setDefaultButton(button);
        }
        return button;
    }

    private void setMargin(JButton button) {
        if (!SystemInfo.isMac) {
            if (this.myButtonMargins == null) {
                return;
            }
            button.setMargin(this.myButtonMargins);
        }
    }

    protected JComponent createTitlePane() {
        return null;
    }

    protected JComponent createNorthPanel() {
        return null;
    }

    @Nullable
    protected abstract JComponent createCenterPanel();

    public void toFront() {
        this.myPeer.toFront();
    }

    public void toBack() {
        this.myPeer.toBack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        Object object = ourLock;
        synchronized (object) {
            JRootPane rootPane = this.getRootPane();
            if (rootPane != null) {
                new AwtVisitor(rootPane){

                    public boolean visit(Component component) {
                        if (component instanceof JComponent) {
                            KeyStroke[] strokes;
                            JComponent eachComp = (JComponent)component;
                            for (KeyStroke eachStroke : strokes = eachComp.getRegisteredKeyStrokes()) {
                                eachComp.unregisterKeyboardAction(eachStroke);
                            }
                        }
                        return false;
                    }
                };
                this.myPeer.dispose();
            }
        }
    }

    public void doCancelAction() {
        if (this.getCancelAction().isEnabled()) {
            this.close(1);
        }
    }

    public void clickDefaultButton() {
        JButton button = this.getRootPane().getDefaultButton();
        if (button != null) {
            button.doClick();
        }
    }

    protected void doOKAction() {
        if (this.getOKAction().isEnabled()) {
            this.close(0);
        }
    }

    public boolean shouldCloseOnCross() {
        return this.myCrossClosesWindow;
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction()};
    }

    protected Action[] createLeftSideActions() {
        return new Action[0];
    }

    protected Action getOKAction() {
        return this.myOKAction;
    }

    protected Action getCancelAction() {
        return this.myCancelAction;
    }

    protected Action getHelpAction() {
        return this.myHelpAction;
    }

    protected boolean isProgressDialog() {
        return false;
    }

    public final boolean isModalProgress() {
        return this.isProgressDialog();
    }

    public Container getContentPane() {
        return this.myPeer.getContentPane();
    }

    public void validate() {
        this.myPeer.validate();
    }

    public void repaint() {
        this.myPeer.repaint();
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return null;
    }

    public final String getDimensionKey() {
        return this.getDimensionServiceKey();
    }

    public int getExitCode() {
        return this.myExitCode;
    }

    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    public final float getHorizontalStretch() {
        return this.myHorizontalStretch;
    }

    public final float getVerticalStretch() {
        return this.myVerticalStretch;
    }

    protected final void setHorizontalStretch(float hStretch) {
        this.myHorizontalStretch = hStretch;
    }

    protected final void setVerticalStretch(float vStretch) {
        this.myVerticalStretch = vStretch;
    }

    public Window getOwner() {
        return this.myPeer.getOwner();
    }

    public Window getWindow() {
        return this.myPeer.getWindow();
    }

    public JRootPane getRootPane() {
        return this.myPeer.getRootPane();
    }

    public Dimension getSize() {
        return this.myPeer.getSize();
    }

    public String getTitle() {
        return this.myPeer.getTitle();
    }

    protected void init() {
        JComponent centerPanel;
        this.myErrorText = new ErrorText();
        JComponent titlePane = this.createTitlePane();
        JComponent contentPane = this.createContentPane();
        if (titlePane != null) {
            JPanel newContent = new JPanel(new BorderLayout());
            newContent.add((Component)titlePane, "North");
            newContent.add((Component)contentPane, "Center");
            this.myPeer.setContentPane(newContent);
        } else {
            this.myPeer.setContentPane(contentPane);
        }
        contentPane.setLayout(new BorderLayout());
        Border contentPaneBorder = this.createContentPaneBorder();
        contentPane.setBorder(contentPaneBorder);
        JComponent northPanel = this.createNorthPanel();
        if (northPanel != null) {
            contentPane.add((Component)northPanel, "North");
        }
        if ((centerPanel = this.createCenterPanel()) != null) {
            contentPane.add((Component)centerPanel, "Center");
        }
        JComponent southPanel = this.createSouthPanel();
        NonOpaquePanel southWrapper = new NonOpaquePanel(new BorderLayout());
        southWrapper.add((Component)this.myErrorText, "Center");
        if (southPanel != null) {
            southWrapper.add((Component)southPanel, "South");
        }
        contentPane.add((Component)southWrapper, "South");
        new MnemonicHelper().register(contentPane);
    }

    protected JComponent createContentPane() {
        return new JPanel();
    }

    public void pack() {
        this.myPeer.pack();
    }

    public Dimension getPreferredSize() {
        return this.myPeer.getPreferredSize();
    }

    protected final void setButtonsAlignment(int alignment) {
        if (0 != alignment && 4 != alignment) {
            throw new IllegalArgumentException("unknown alignment: " + alignment);
        }
        this.myButtonAlignment = alignment;
    }

    public final void setButtonsMargin(Insets insets) {
        this.myButtonMargins = insets;
    }

    public final void setCrossClosesWindow(boolean crossClosesWindow) {
        this.myCrossClosesWindow = crossClosesWindow;
    }

    protected final void setCancelButtonIcon(Icon icon) {
        if (!SystemInfo.isMac) {
            this.myCancelAction.putValue("SmallIcon", icon);
        }
    }

    protected final void setCancelButtonText(String text) {
        this.myCancelAction.putValue("Name", text);
    }

    public void setModal(boolean modal) {
        this.myPeer.setModal(modal);
    }

    protected void setOKActionEnabled(boolean isEnabled) {
        this.myOKAction.setEnabled(isEnabled);
    }

    protected final void setOKButtonIcon(Icon icon) {
        if (!SystemInfo.isMac) {
            this.myOKAction.putValue("SmallIcon", icon);
        }
    }

    protected final void setOKButtonText(String text) {
        this.myOKAction.putValue("Name", text);
    }

    protected void doHelpAction() {
        if (this.myHelpAction.isEnabled()) {
            Messages.showMessageDialog(this.getContentPane(), UIBundle.message("there.is.no.help.for.this.dialog.error.message", new Object[0]), UIBundle.message("no.help.available.dialog.title", new Object[0]), Messages.getInformationIcon());
        }
    }

    public boolean isOK() {
        return this.myExitCode == 0;
    }

    public boolean isOKActionEnabled() {
        return this.myOKAction.isEnabled();
    }

    public boolean isVisible() {
        return this.myPeer.isVisible();
    }

    public boolean isShowing() {
        return this.myPeer.isShowing();
    }

    public void setSize(int width, int height) {
        this.myPeer.setSize(width, height);
    }

    public void setTitle(String title) {
        this.myPeer.setTitle(title);
    }

    public void isResizable() {
        this.myPeer.isResizable();
    }

    public void setResizable(boolean resizable) {
        this.myPeer.setResizable(resizable);
    }

    public Point getLocation() {
        return this.myPeer.getLocation();
    }

    public void setLocation(Point p) {
        this.myPeer.setLocation(p);
    }

    public void setLocation(int x, int y) {
        this.myPeer.setLocation(x, y);
    }

    public void centerRelativeToParent() {
        this.myPeer.centerInParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show() {
        Object object = ourLock;
        synchronized (object) {
            this.registerKeyboardShortcuts();
            this.myPeer.show();
        }
    }

    @Nullable
    public Point getInitialLocation() {
        return null;
    }

    private void registerKeyboardShortcuts() {
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                MenuElement[] selectedPath = menuSelectionManager.getSelectedPath();
                if (selectedPath.length > 0) {
                    menuSelectionManager.clearSelectedPath();
                } else if (!StackingPopupDispatcher.getInstance().isPopupFocused()) {
                    DialogWrapper.this.doCancelAction();
                }
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogWrapper.this.doHelpAction();
            }
        }, KeyStroke.getKeyStroke(112, 0), 2);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogWrapper.this.doHelpAction();
            }
        }, KeyStroke.getKeyStroke(156, 0), 2);
        if (this.myButtons != null) {
            this.getRootPane().registerKeyboardAction(new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    DialogWrapper.this.focusPreviousButton();
                }
            }, KeyStroke.getKeyStroke(37, 0), 1);
            this.getRootPane().registerKeyboardAction(new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    DialogWrapper.this.focusNextButton();
                }
            }, KeyStroke.getKeyStroke(39, 0), 1);
        }
        if (this.myYesAction != null) {
            this.getRootPane().registerKeyboardAction(this.myYesAction, KeyStroke.getKeyStroke(89, 0), 2);
        }
        if (this.myNoAction != null) {
            this.getRootPane().registerKeyboardAction(this.myNoAction, KeyStroke.getKeyStroke(78, 0), 2);
        }
    }

    private void focusPreviousButton() {
        for (int i = 0; i < this.myButtons.length; ++i) {
            if (!this.myButtons[i].hasFocus()) continue;
            if (i == 0) {
                this.myButtons[this.myButtons.length - 1].requestFocus();
                return;
            }
            this.myButtons[i - 1].requestFocus();
            return;
        }
    }

    private void focusNextButton() {
        for (int i = 0; i < this.myButtons.length; ++i) {
            if (!this.myButtons[i].hasFocus()) continue;
            if (i == this.myButtons.length - 1) {
                this.myButtons[0].requestFocus();
                return;
            }
            this.myButtons[i + 1].requestFocus();
            return;
        }
    }

    protected final void setErrorText(@Nullable String text) {
        this.myErrorText.setError(text);
        this.updateHeightForErrorText();
        this.myErrorText.repaint();
    }

    private void updateHeightForErrorText() {
        int minHeight = this.getContentPane().getMinimumSize().height;
        if (this.getContentPane().getHeight() < minHeight) {
            this.myPeer.setSize(this.myPeer.getSize().width, minHeight);
        }
    }

    public final DialogWrapperPeer getPeer() {
        return this.myPeer;
    }

    private static class ErrorText
    extends JPanel {
        private JLabel myLabel = new JLabel();
        private Dimension myPrefSize;

        public ErrorText() {
            this.setLayout(new BorderLayout());
            this.setBorder(null);
            UIUtil.removeQuaquaVisualMarginsIn(this);
            this.add((Component)this.myLabel, "Center");
        }

        public void setError(String text) {
            if (text == null) {
                this.myLabel.setText("");
                this.myLabel.setIcon(null);
                this.setBorder(null);
            } else {
                this.myLabel.setText("<html><body><font color=red><left>" + text + "</left></b></font></body></html>");
                this.myLabel.setIcon(IconLoader.getIcon("/actions/lightning.png"));
                this.myLabel.setBorder(new EmptyBorder(2, 2, 0, 0));
                if (this.myPrefSize == null) {
                    this.myPrefSize = this.myLabel.getPreferredSize();
                }
            }
            this.revalidate();
        }

        public Dimension getPreferredSize() {
            return this.myPrefSize == null ? super.getPreferredSize() : this.myPrefSize;
        }
    }

    private class HelpAction
    extends AbstractAction {
        public HelpAction() {
            this.putValue("Name", CommonBundle.getHelpButtonText());
        }

        public void actionPerformed(ActionEvent e) {
            DialogWrapper.this.doHelpAction();
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", CommonBundle.getCancelButtonText());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            if (DialogWrapper.this.myClosed) {
                return;
            }
            if (DialogWrapper.this.myPerformAction) {
                return;
            }
            try {
                DialogWrapper.this.myPerformAction = true;
                DialogWrapper.this.doCancelAction();
            }
            finally {
                DialogWrapper.this.myPerformAction = false;
            }
        }
    }

    private class OkAction
    extends AbstractAction {
        public OkAction() {
            this.putValue("Name", CommonBundle.getOkButtonText());
            this.putValue(DialogWrapper.DEFAULT_ACTION, Boolean.TRUE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            if (DialogWrapper.this.myClosed) {
                return;
            }
            if (DialogWrapper.this.myPerformAction) {
                return;
            }
            try {
                DialogWrapper.this.myPerformAction = true;
                DialogWrapper.this.doOKAction();
            }
            finally {
                DialogWrapper.this.myPerformAction = false;
            }
        }
    }
}

