/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogBuilder {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.ui.DialogBuilder");
    @NonNls
    public static final String REQUEST_FOCUS_ENABLED = "requestFocusEnabled";
    private JComponent myCenterPanel;
    private String myTitle;
    private JComponent myPreferedFocusComponent;
    private String myDimensionServiceKey;
    private ArrayList<ActionDescriptor> myActions = null;
    private final MyDialogWrapper myDialogWrapper;
    private final ArrayList<Disposable> myDisposables = new ArrayList();
    private Runnable myCancelOperation = null;
    private Runnable myOkOperation = null;

    public int show() {
        return this.showImpl(true).getExitCode();
    }

    public void showNotModal() {
        this.showImpl(false);
    }

    public DialogBuilder(Project project) {
        this.myDialogWrapper = new MyDialogWrapper(project, true);
    }

    public DialogBuilder(Component parent) {
        this.myDialogWrapper = new MyDialogWrapper(parent, true);
    }

    private MyDialogWrapper showImpl(boolean isModal) {
        LOG.assertTrue(this.myTitle != null && this.myTitle.trim().length() != 0, String.valueOf(this.myTitle));
        this.myDialogWrapper.setTitle(this.myTitle);
        this.myDialogWrapper.init();
        this.myDialogWrapper.setModal(isModal);
        this.myDialogWrapper.show();
        if (isModal) {
            this.myDialogWrapper.dispose();
        }
        return this.myDialogWrapper;
    }

    public void setCenterPanel(JComponent centerPanel) {
        this.myCenterPanel = centerPanel;
    }

    public void setTitle(String title) {
        this.myTitle = title;
    }

    public void setPreferedFocusComponent(JComponent component) {
        this.myPreferedFocusComponent = component;
    }

    public void setDimensionServiceKey(@NonNls String dimensionServiceKey) {
        this.myDimensionServiceKey = dimensionServiceKey;
    }

    public void addAction(Action action) {
        this.addActionDescriptor(new CustomActionDescriptor(action));
    }

    public <T extends ActionDescriptor> T addActionDescriptor(T actionDescriptor) {
        this.getActionDescriptors().add(actionDescriptor);
        return actionDescriptor;
    }

    private ArrayList<ActionDescriptor> getActionDescriptors() {
        if (this.myActions == null) {
            this.removeAllActions();
        }
        return this.myActions;
    }

    public void setActionDescriptors(ActionDescriptor[] descriptors) {
        this.removeAllActions();
        for (ActionDescriptor descriptor : descriptors) {
            this.myActions.add(descriptor);
        }
    }

    public void removeAllActions() {
        this.myActions = new ArrayList();
    }

    public Window getWindow() {
        return this.myDialogWrapper.getWindow();
    }

    public CustomizableAction addOkAction() {
        return this.addActionDescriptor(new OkActionDescriptor());
    }

    public CustomizableAction addCancelAction() {
        return this.addActionDescriptor(new CancelActionDescriptor());
    }

    public CustomizableAction addCloseButton() {
        CustomizableAction closeAction = this.addOkAction();
        closeAction.setText(CommonBundle.getCloseButtonText());
        return closeAction;
    }

    public void addDisposable(Disposable disposable) {
        this.myDisposables.add(disposable);
    }

    public void setButtonsAlignment(int alignment) {
        this.myDialogWrapper.setButtonsAlignment1(alignment);
    }

    public DialogWrapper getDialogWrapper() {
        return this.myDialogWrapper;
    }

    public void showModal(boolean modal) {
        if (modal) {
            this.show();
        } else {
            this.showNotModal();
        }
    }

    public void setHelpId(@NonNls String helpId) {
        this.myDialogWrapper.setHelpId(helpId);
    }

    public void setCancelOperation(Runnable runnable) {
        this.myCancelOperation = runnable;
    }

    public void setOkOperation(Runnable runnable) {
        this.myOkOperation = runnable;
    }

    public void setOkActionEnabled(boolean isEnabled) {
        this.myDialogWrapper.setOKActionEnabled(isEnabled);
    }

    public CustomizableAction getOkAction() {
        return DialogBuilder.get(this.getActionDescriptors(), OkActionDescriptor.class);
    }

    private static CustomizableAction get(ArrayList<ActionDescriptor> actionDescriptors, Class aClass) {
        for (ActionDescriptor actionDescriptor : actionDescriptors) {
            if (!actionDescriptor.getClass().isAssignableFrom(aClass)) continue;
            return (CustomizableAction)((Object)actionDescriptor);
        }
        return null;
    }

    public CustomizableAction getCancelAction() {
        return DialogBuilder.get(this.getActionDescriptors(), CancelActionDescriptor.class);
    }

    public Component getCenterPanel() {
        return this.myCenterPanel;
    }

    private class MyDialogWrapper
    extends DialogWrapper {
        private String myHelpId;

        public MyDialogWrapper(Project project, boolean canBeParent) {
            super(project, canBeParent);
            this.myHelpId = null;
        }

        public MyDialogWrapper(Component parent, boolean canBeParent) {
            super(parent, canBeParent);
            this.myHelpId = null;
        }

        public void setHelpId(String helpId) {
            this.myHelpId = helpId;
        }

        public void init() {
            super.init();
        }

        public Action getOKAction() {
            return super.getOKAction();
        }

        public Action getCancelAction() {
            return super.getCancelAction();
        }

        public void setButtonsAlignment1(int alignment) {
            this.setButtonsAlignment(alignment);
        }

        protected JComponent createCenterPanel() {
            return DialogBuilder.this.myCenterPanel;
        }

        public void dispose() {
            DialogBuilder.this.myPreferedFocusComponent = null;
            for (Disposable disposable : DialogBuilder.this.myDisposables) {
                disposable.dispose();
            }
            super.dispose();
        }

        public JComponent getPreferredFocusedComponent() {
            if (DialogBuilder.this.myPreferedFocusComponent != null) {
                return DialogBuilder.this.myPreferedFocusComponent;
            }
            FocusTraversalPolicy focusTraversalPolicy = null;
            for (Container container = DialogBuilder.this.myCenterPanel; container != null && (focusTraversalPolicy = container.getFocusTraversalPolicy()) == null && !(container instanceof Window); container = container.getParent()) {
            }
            if (focusTraversalPolicy == null) {
                return null;
            }
            Component component = focusTraversalPolicy.getDefaultComponent(DialogBuilder.this.myCenterPanel);
            while (!(component instanceof JComponent) && component != null) {
                component = focusTraversalPolicy.getComponentAfter(DialogBuilder.this.myCenterPanel, component);
            }
            return (JComponent)component;
        }

        protected String getDimensionServiceKey() {
            return DialogBuilder.this.myDimensionServiceKey;
        }

        protected JButton createJButtonForAction(Action action) {
            JButton button = super.createJButtonForAction(action);
            Object value = action.getValue(DialogBuilder.REQUEST_FOCUS_ENABLED);
            if (value instanceof Boolean) {
                button.setRequestFocusEnabled((Boolean)value);
            }
            return button;
        }

        public void doCancelAction() {
            if (!this.getCancelAction().isEnabled()) {
                return;
            }
            if (DialogBuilder.this.myCancelOperation != null) {
                DialogBuilder.this.myCancelOperation.run();
            } else {
                super.doCancelAction();
            }
        }

        protected void doOKAction() {
            if (DialogBuilder.this.myOkOperation != null) {
                DialogBuilder.this.myOkOperation.run();
            } else {
                super.doOKAction();
            }
        }

        protected void doHelpAction() {
            if (this.myHelpId == null) {
                super.doHelpAction();
                return;
            }
            HelpManager.getInstance().invokeHelp(this.myHelpId);
        }

        protected Action[] createActions() {
            if (DialogBuilder.this.myActions == null) {
                return super.createActions();
            }
            ArrayList<Action> actions = new ArrayList<Action>(DialogBuilder.this.myActions.size());
            for (ActionDescriptor actionDescriptor : DialogBuilder.this.myActions) {
                actions.add(actionDescriptor.getAction(this));
            }
            if (this.myHelpId != null) {
                actions.add(this.getHelpAction());
            }
            return actions.toArray(new Action[actions.size()]);
        }
    }

    public static class CancelActionDescriptor
    extends BuiltinAction {
        protected Action getBuiltinAction(MyDialogWrapper dialogWrapper) {
            return dialogWrapper.getCancelAction();
        }
    }

    public static class OkActionDescriptor
    extends BuiltinAction {
        protected Action getBuiltinAction(MyDialogWrapper dialogWrapper) {
            return dialogWrapper.getOKAction();
        }
    }

    private static abstract class BuiltinAction
    implements ActionDescriptor,
    CustomizableAction {
        protected String myText = null;

        private BuiltinAction() {
        }

        public void setText(String text) {
            this.myText = text;
        }

        public Action getAction(DialogWrapper dialogWrapper) {
            Action builtinAction = this.getBuiltinAction((MyDialogWrapper)dialogWrapper);
            if (this.myText != null) {
                builtinAction.putValue("Name", this.myText);
            }
            return builtinAction;
        }

        protected abstract Action getBuiltinAction(MyDialogWrapper var1);
    }

    public static class CustomActionDescriptor
    implements ActionDescriptor {
        private final Action myAction;

        public CustomActionDescriptor(Action action) {
            this.myAction = action;
        }

        public Action getAction(DialogWrapper dialogWrapper) {
            return this.myAction;
        }
    }

    public static interface CustomizableAction {
        public void setText(String var1);
    }

    public static class CloseDialogAction
    extends DialogActionDescriptor {
        private final int myExitCode;

        public CloseDialogAction(String name, int mnemonicChar, int exitCode) {
            super(name, mnemonicChar);
            this.myExitCode = exitCode;
        }

        public static CloseDialogAction createDefault(String name, int mnemonicChar, int exitCode) {
            CloseDialogAction closeDialogAction = new CloseDialogAction(name, mnemonicChar, exitCode);
            closeDialogAction.setDefault(true);
            return closeDialogAction;
        }

        protected Action createAction(final DialogWrapper dialogWrapper) {
            return new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    dialogWrapper.close(CloseDialogAction.this.myExitCode);
                }
            };
        }
    }

    public static abstract class DialogActionDescriptor
    implements ActionDescriptor {
        private final String myName;
        private final Object myMnemonicChar;
        private boolean myIsDeafult = false;

        protected DialogActionDescriptor(String name, int mnemonicChar) {
            this.myName = name;
            this.myMnemonicChar = mnemonicChar != -1 ? new Integer(mnemonicChar) : null;
        }

        public Action getAction(DialogWrapper dialogWrapper) {
            Action action = this.createAction(dialogWrapper);
            action.putValue("Name", this.myName);
            if (this.myMnemonicChar != null) {
                action.putValue("MnemonicKey", this.myMnemonicChar);
            }
            if (this.myIsDeafult) {
                action.putValue("Default", Boolean.TRUE);
            }
            return action;
        }

        public void setDefault(boolean isDefault) {
            this.myIsDeafult = isDefault;
        }

        protected abstract Action createAction(DialogWrapper var1);
    }

    public static interface ActionDescriptor {
        public Action getAction(DialogWrapper var1);
    }
}

