/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.ui.NullableComponent;
import com.intellij.openapi.wm.impl.content.GraphicsConfig;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.Nullable;

public class DetailsComponent {
    private JPanel myComponent = new JPanel(new BorderLayout()){

        protected void paintComponent(Graphics g) {
            if (NullableComponent.Check.isNull(DetailsComponent.this.myContentWrapper)) {
                return;
            }
            GraphicsConfig c = new GraphicsConfig(g);
            c.setAntialiasing(true);
            int arc = 8;
            Insets insets = this.getInsets();
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            g.setColor(UIUtil.getFocusedFillColor());
            Rectangle banner = DetailsComponent.this.myBanner.getBounds();
            GeneralPath header = new GeneralPath();
            int leftX = insets.left;
            int leftY = insets.top;
            int rightX = insets.left + this.getWidth() - 1 - insets.right;
            int rightY = banner.y + banner.height;
            header.moveTo(leftX, rightY);
            header.lineTo(leftX, leftY + arc);
            header.quadTo(leftX, leftY, leftX + arc, leftY);
            header.lineTo(rightX - arc, leftY);
            header.quadTo(rightX, leftY, rightX, leftY + arc);
            header.lineTo(rightX, rightY);
            header.closePath();
            c.getG().fill(header);
            g.setColor(UIUtil.getFocusedBoundsColor());
            c.getG().draw(header);
            int down = this.getHeight() - insets.top - insets.bottom - 1;
            g.drawLine(leftX, rightY, leftX, down);
            g.drawLine(rightX, rightY, rightX, down);
            g.drawLine(leftX, down, rightX, down);
            c.restore();
        }
    };
    private JComponent myContentWrapper;
    private Banner myBannerLabel;
    private JLabel myEmptyContentLabel;
    private NonOpaquePanel myBanner;

    public DetailsComponent() {
        this.myComponent.setOpaque(false);
        this.myBanner = new NonOpaquePanel(new BorderLayout());
        this.myBannerLabel = new Banner();
        this.myBanner.add((Component)this.myBannerLabel, "Center");
        this.myComponent.add((Component)this.myBanner, "North");
        this.myEmptyContentLabel = new JLabel("", 0);
    }

    public void setContent(@Nullable JComponent c) {
        if (this.myContentWrapper != null) {
            this.myComponent.remove(this.myContentWrapper);
        }
        this.myContentWrapper = new MyWrapper(c);
        this.myContentWrapper.setOpaque(false);
        this.myContentWrapper.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.myComponent.add((Component)this.myContentWrapper, "Center");
        this.myComponent.revalidate();
        this.myComponent.repaint();
    }

    public void setText(String text) {
        this.myBannerLabel.setText(text);
    }

    public void setEmptyContentText(@Nullable String emptyContentText) {
        String s = "<html><body><center>" + (emptyContentText != null ? emptyContentText : "") + "</center></body><html>";
        this.myEmptyContentLabel.setText(s);
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public void setBannerMinHeight(int height) {
        this.myBannerLabel.setMinHeight(height);
    }

    public void disposeUIResources() {
        this.setContent(null);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new BorderLayout());
        JPanel content = new JPanel(new BorderLayout());
        DetailsComponent d = new DetailsComponent();
        content.add((Component)d.getComponent(), "Center");
        d.setText("This is a Tree");
        JTree c = new JTree();
        c.setBorder(new LineBorder(Color.red));
        d.setContent(c);
        frame.getContentPane().add((Component)content, "Center");
        frame.setBounds(300, 300, 300, 300);
        frame.show();
    }

    private class MyWrapper
    extends Wrapper
    implements NullableComponent {
        public MyWrapper(JComponent c) {
            super(c == null ? DetailsComponent.this.myEmptyContentLabel : c);
        }

        public boolean isNull() {
            return this.getTargetComponent() == DetailsComponent.this.myEmptyContentLabel;
        }
    }

    public static interface Facade {
        public DetailsComponent getDetailsComponent();
    }

    private class Banner
    extends JLabel {
        private int myBannerMinHeight;

        public Banner() {
            super("", 2);
            this.setFont(this.getFont().deriveFont(1));
            this.setBorder(new EmptyBorder(2, 6, 2, 4));
        }

        public Dimension getMinimumSize() {
            Dimension size = super.getMinimumSize();
            size.height = this.myBannerMinHeight > 0 ? this.myBannerMinHeight : size.height;
            return size;
        }

        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.height = this.getMinimumSize().height;
            return size;
        }

        public void setMinHeight(int height) {
            this.myBannerMinHeight = height;
            this.revalidate();
            this.repaint();
        }
    }
}

