/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.UIBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentWithBrowseButton<Comp extends JComponent>
extends JPanel {
    private final Comp myComponent;
    private final FixedSizeButton myBrowseButton;
    private boolean myButtonEnabled = true;
    private KeyEvent myCurrentEvent = null;

    public ComponentWithBrowseButton(Comp component, ActionListener browseActionListener) {
        super(new BorderLayout(SystemInfo.isMac ? 0 : 2, 0));
        this.myComponent = component;
        this.add((Component)this.myComponent, "Center");
        this.myBrowseButton = new FixedSizeButton((JComponent)this.myComponent);
        if (browseActionListener != null) {
            this.myBrowseButton.addActionListener(browseActionListener);
        }
        this.add((Component)this.myBrowseButton, "East");
        this.myBrowseButton.setToolTipText(UIBundle.message("component.with.browse.button.browse.button.tooltip.text", new Object[0]));
        new MyDoClickAction(this.myBrowseButton).registerShortcut((JComponent)this.myComponent);
    }

    public final Comp getChildComponent() {
        return this.myComponent;
    }

    public void setTextFieldPreferredWidth(int charCount) {
        Comp comp = this.getChildComponent();
        Dimension size = ((JComponent)comp).getPreferredSize();
        FontMetrics fontMetrics = ((JComponent)comp).getFontMetrics(((Component)comp).getFont());
        size.width = fontMetrics.charWidth('a') * charCount;
        ((JComponent)comp).setPreferredSize(size);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myBrowseButton.setEnabled(enabled && this.myButtonEnabled);
        ((JComponent)this.myComponent).setEnabled(enabled);
    }

    public void setButtonEnabled(boolean buttonEnabled) {
        this.myButtonEnabled = buttonEnabled;
        this.setEnabled(this.isEnabled());
    }

    public void setButtonIcon(Icon icon) {
        this.myBrowseButton.setIcon(icon);
    }

    public void addActionListener(ActionListener listener) {
        this.myBrowseButton.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.myBrowseButton.removeActionListener(listener);
    }

    public void addBrowseFolderListener(String title, String description, Project project, FileChooserDescriptor fileChooserDescriptor, TextComponentAccessor<Comp> accessor) {
        final BrowseFolderActionListener<Comp> actionListener = new BrowseFolderActionListener<Comp>(title, description, this, project, fileChooserDescriptor, accessor);
        if (project == null) {
            project = DataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
        }
        if (project != null) {
            Disposer.register(project, new Disposable(){

                public void dispose() {
                    ComponentWithBrowseButton.this.removeActionListener(actionListener);
                }
            });
        }
        this.addActionListener(actionListener);
    }

    public FixedSizeButton getButton() {
        return this.myBrowseButton;
    }

    @Override
    public final void requestFocus() {
        ((JComponent)this.myComponent).requestFocus();
    }

    @Override
    public final void setNextFocusableComponent(Component aComponent) {
        ((JComponent)this.myComponent).setNextFocusableComponent(aComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (condition == 0 && this.myCurrentEvent != e) {
            try {
                this.myCurrentEvent = e;
                ((Component)this.myComponent).dispatchEvent(e);
            }
            finally {
                this.myCurrentEvent = null;
            }
        }
        if (e.isConsumed()) {
            return true;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BrowseFolderActionListener<T extends JComponent>
    implements ActionListener {
        private final String myTitle;
        private final String myDescription;
        private final ComponentWithBrowseButton<T> myTextComponent;
        private final TextComponentAccessor<T> myAccessor;
        private final Project myProject;
        private FileChooserDescriptor myFileChooserDescriptor;

        public BrowseFolderActionListener(String title, String description, ComponentWithBrowseButton<T> textField, Project project, FileChooserDescriptor fileChooserDescriptor, TextComponentAccessor<T> accessor) {
            this.myTitle = title;
            this.myDescription = description;
            this.myTextComponent = textField;
            this.myProject = project;
            this.myFileChooserDescriptor = fileChooserDescriptor;
            this.myAccessor = accessor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileChooserDescriptor fileChooserDescriptor = (FileChooserDescriptor)this.myFileChooserDescriptor.clone();
            if (this.myTitle != null) {
                fileChooserDescriptor.setTitle(this.myTitle);
            }
            if (this.myDescription != null) {
                fileChooserDescriptor.setDescription(this.myDescription);
            }
            String directoryName = this.myAccessor.getText(this.myTextComponent.getChildComponent()).trim();
            VirtualFile initialFile = LocalFileSystem.getInstance().findFileByPath(directoryName.replace(File.separatorChar, '/'));
            VirtualFile[] files = this.doChoose(fileChooserDescriptor, initialFile);
            if (files != null && files.length != 0) {
                this.onFileChoosen(files[0]);
            }
        }

        protected void onFileChoosen(VirtualFile chosenFile) {
            this.myAccessor.setText(this.myTextComponent.getChildComponent(), chosenFile.getPresentableUrl());
        }

        private VirtualFile[] doChoose(FileChooserDescriptor fileChooserDescriptor, VirtualFile initialFile) {
            if (this.myProject == null) {
                return FileChooser.chooseFiles(this.myTextComponent, fileChooserDescriptor, initialFile);
            }
            return FileChooser.chooseFiles(this.myProject, fileChooserDescriptor, initialFile);
        }
    }

    public static final class MyDoClickAction
    extends AnAction {
        private final FixedSizeButton myBrowseButton;
        private JComponent myFocusedComponent;

        public MyDoClickAction(FixedSizeButton browseButton) {
            this.myBrowseButton = browseButton;
        }

        public void actionPerformed(AnActionEvent e) {
            this.myBrowseButton.doClick();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (MyDoClickAction.this.myFocusedComponent != null) {
                        MyDoClickAction.this.myFocusedComponent.requestFocus();
                    }
                }
            });
        }

        public void registerShortcut(JComponent textField) {
            CustomShortcutSet shiftEnter = new CustomShortcutSet(KeyStroke.getKeyStroke(10, 64));
            this.registerCustomShortcutSet(shiftEnter, textField);
            this.myBrowseButton.setToolTipText(KeymapUtil.getShortcutsText(shiftEnter.getShortcuts()));
            this.myFocusedComponent = textField;
        }

        public static void addTo(FixedSizeButton browseButton, JComponent aComponent) {
            new MyDoClickAction(browseButton).registerShortcut(aComponent);
        }
    }
}

