/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.JBComboBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.CellEditor;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

public class ComboBox
extends JBComboBox {
    private int myMinimumAndPreferredWidth;

    public ComboBox() {
        this(-1);
    }

    public ComboBox(int minimumAndPreferredWidth) {
        this(new DefaultComboBoxModel(), minimumAndPreferredWidth);
    }

    public ComboBox(ComboBoxModel model, int minimumAndPreferredWidth) {
        super(model);
        this.myMinimumAndPreferredWidth = minimumAndPreferredWidth;
        this.registerCancelOnEscape();
    }

    public ComboBox(Object[] items, int preferredWidth) {
        super(items);
        this.myMinimumAndPreferredWidth = preferredWidth;
        this.registerCancelOnEscape();
    }

    public void setMinimumAndPreferredWidth(int minimumAndPreferredWidth) {
        this.myMinimumAndPreferredWidth = minimumAndPreferredWidth;
    }

    private static DialogWrapperDialog getParentDialog(Component c) {
        while (c != null && !(c instanceof DialogWrapperDialog)) {
            c = c.getParent();
        }
        return (DialogWrapperDialog)((Object)c);
    }

    private void registerCancelOnEscape() {
        this.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogWrapper dialogWrapper;
                DialogWrapperDialog dialogWrapperDialog = ComboBox.getParentDialog(ComboBox.this);
                DialogWrapper dialogWrapper2 = dialogWrapper = dialogWrapperDialog == null ? null : dialogWrapperDialog.getDialogWrapper();
                if (ComboBox.this.isPopupVisible()) {
                    ComboBox.this.setPopupVisible(false);
                } else {
                    Object clientProperty = ComboBox.this.getClientProperty("tableCellEditor");
                    if (clientProperty instanceof CellEditor) {
                        ((CellEditor)clientProperty).cancelCellEditing();
                    } else if (dialogWrapper != null) {
                        dialogWrapper.doCancelAction();
                    }
                }
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    public final void setEditor(ComboBoxEditor editor) {
        super.setEditor(new MyEditor(this, editor));
    }

    public final Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public final Dimension getPreferredSize() {
        int width = this.myMinimumAndPreferredWidth;
        if (width < 0) {
            width = super.getPreferredSize().width;
        }
        int height = this.getPreferredHeight();
        return new Dimension(width, height);
    }

    protected Dimension getOriginalPreferredSize() {
        return super.getPreferredSize();
    }

    private int getPreferredHeight() {
        int height;
        Border border = this.getBorder();
        ComboBoxEditor editor = this.getEditor();
        if (editor != null) {
            height = editor.getEditorComponent().getPreferredSize().height;
            if (border != null) {
                height += border.getBorderInsets((Component)this).top + border.getBorderInsets((Component)this).bottom;
            }
        } else {
            height = super.getPreferredSize().height;
        }
        return height;
    }

    private static final class MyEditor
    implements ComboBoxEditor {
        private final JComboBox myComboBox;
        private final ComboBoxEditor myDelegate;

        public MyEditor(JComboBox comboBox, ComboBoxEditor delegate) {
            this.myComboBox = comboBox;
            this.myDelegate = delegate;
            if (this.myDelegate != null) {
                this.myDelegate.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (MyEditor.this.myComboBox.isPopupVisible()) {
                            MyEditor.this.myComboBox.setPopupVisible(false);
                        } else {
                            Object clientProperty = MyEditor.this.myComboBox.getClientProperty("tableCellEditor");
                            if (clientProperty instanceof CellEditor) {
                                ((CellEditor)clientProperty).stopCellEditing();
                            } else {
                                JButton button;
                                MyEditor.this.myComboBox.setSelectedItem(MyEditor.this.getItem());
                                JRootPane rootPane = MyEditor.this.myComboBox.getRootPane();
                                if (rootPane != null && (button = rootPane.getDefaultButton()) != null) {
                                    button.doClick();
                                }
                            }
                        }
                    }
                });
            }
        }

        public void addActionListener(ActionListener l) {
        }

        public Component getEditorComponent() {
            if (this.myDelegate != null) {
                return this.myDelegate.getEditorComponent();
            }
            return null;
        }

        public Object getItem() {
            if (this.myDelegate != null) {
                return this.myDelegate.getItem();
            }
            return null;
        }

        public void removeActionListener(ActionListener l) {
        }

        public void selectAll() {
            if (this.myDelegate != null) {
                this.myDelegate.selectAll();
            }
        }

        public void setItem(Object obj) {
            if (this.myDelegate != null) {
                this.myDelegate.setItem(obj);
            }
        }
    }
}

