/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.util.IconLoader;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class SdkType {
    private final String myName;

    @Nullable
    public abstract String suggestHomePath();

    public abstract boolean isValidSdkHome(String var1);

    @Nullable
    public String getVersionString(Sdk sdk) {
        return this.getVersionString(sdk.getHomePath());
    }

    @Nullable
    public String getVersionString(String sdkHome) {
        return null;
    }

    public abstract String suggestSdkName(String var1, String var2);

    public void setupSdkPaths(Sdk sdk) {
    }

    public boolean setupSdkPaths(Sdk sdk, SdkModel sdkModel) {
        this.setupSdkPaths(sdk);
        return true;
    }

    public abstract AdditionalDataConfigurable createAdditionalDataConfigurable(SdkModel var1, SdkModificator var2);

    @Nullable
    public abstract String getBinPath(Sdk var1);

    @Nullable
    public abstract String getToolsPath(Sdk var1);

    @Nullable
    public abstract String getVMExecutablePath(Sdk var1);

    @Nullable
    public abstract String getRtLibraryPath(Sdk var1);

    @Nullable
    public Sdk getEncapsulatedSdk(Sdk sdk) {
        return null;
    }

    public abstract void saveAdditionalData(SdkAdditionalData var1, Element var2);

    @Nullable
    public SdkAdditionalData loadAdditionalData(Element additional) {
        return null;
    }

    @Nullable
    public SdkAdditionalData loadAdditionalData(Sdk currentSdk, Element additional) {
        return this.loadAdditionalData(additional);
    }

    public SdkType(@NonNls String name) {
        this.myName = name;
    }

    public String getName() {
        return this.myName;
    }

    public abstract String getPresentableName();

    public Icon getIcon() {
        return null;
    }

    public Icon getIconForExpandedTreeNode() {
        return this.getIcon();
    }

    public Icon getIconForAddAction() {
        return IconLoader.getIcon("/general/add.png");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SdkType)) {
            return false;
        }
        SdkType sdkType = (SdkType)o;
        return this.myName.equals(sdkType.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public String toString() {
        return this.getName();
    }
}

