/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.projectRoots.ProjectJdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileFilter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class JavaSdk
extends SdkType
implements ApplicationComponent {
    public JavaSdk(@NonNls String name) {
        super(name);
    }

    public static JavaSdk getInstance() {
        return ApplicationManager.getApplication().getComponent(JavaSdk.class);
    }

    public final ProjectJdk createJdk(String jdkName, String jreHome) {
        return this.createJdk(jdkName, jreHome, true);
    }

    public abstract int compareTo(@NotNull String var1, @NotNull String var2);

    public abstract ProjectJdk createJdk(@NonNls String var1, String var2, boolean var3);

    public static boolean checkForJdk(File file) {
        if (!(file = new File(file.getAbsolutePath() + File.separator + "bin")).exists()) {
            return false;
        }
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return false;
                }
                if (Comparing.strEqual(FileUtil.getNameWithoutExtension(f), "javac")) {
                    return true;
                }
                return Comparing.strEqual(FileUtil.getNameWithoutExtension(f), "javah");
            }
        };
        File[] children = file.listFiles(fileFilter);
        return children != null && children.length >= 2;
    }

    public static boolean checkForJre(String file) {
        File ioFile = new File(new File(file.replace('/', File.separatorChar)).getAbsolutePath() + File.separator + "bin");
        if (!ioFile.exists()) {
            return false;
        }
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return false;
                }
                return Comparing.strEqual(FileUtil.getNameWithoutExtension(f), "java");
            }
        };
        File[] children = ioFile.listFiles(fileFilter);
        return children != null && children.length >= 1;
    }
}

