/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.util.LinkedList;
import java.util.Queue;

public class BackgroundTaskQueue {
    private final Project myProject;
    private final Queue<Task> myQueue = new LinkedList<Task>();
    private boolean myHasActiveTask = false;
    private Task.Backgroundable myRunnerTask;

    public BackgroundTaskQueue(final Project project, String title) {
        this.myProject = project;
        this.myRunnerTask = new Task.Backgroundable(project, title){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(ProgressIndicator indicator) {
                BackgroundTaskQueue.this.myHasActiveTask = true;
                while (true) {
                    Task task;
                    Queue queue = BackgroundTaskQueue.this.myQueue;
                    synchronized (queue) {
                        task = (Task)BackgroundTaskQueue.this.myQueue.poll();
                        if (task == null) {
                            break;
                        }
                    }
                    indicator.setText(task.getTitle());
                    task.run(indicator);
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        public void run() {
                            if (!project.isDisposed()) {
                                task.onSuccess();
                            }
                        }
                    }, ModalityState.NON_MODAL);
                }
                BackgroundTaskQueue.this.myHasActiveTask = false;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Task.Backgroundable task) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            task.run(null);
            task.onSuccess();
        } else if (task.isConditionalModal() && !task.shouldStartInBackground()) {
            ProgressManager.getInstance().run(task);
        } else {
            boolean hadActiveTask;
            Queue<Task> queue = this.myQueue;
            synchronized (queue) {
                hadActiveTask = this.myHasActiveTask;
                this.myQueue.offer(task);
                this.myHasActiveTask = true;
            }
            if (!hadActiveTask) {
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    ProgressManager.getInstance().run(this.myRunnerTask);
                } else {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        public void run() {
                            if (!BackgroundTaskQueue.this.myProject.isDisposed()) {
                                ProgressManager.getInstance().run(BackgroundTaskQueue.this.myRunnerTask);
                            }
                        }
                    });
                }
            }
        }
    }
}

