/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathReference {
    public static final NullableFunction<PathReference, Icon> NULL_ICON = new NullableFunction<PathReference, Icon>(){

        @Override
        public Icon fun(PathReference webPath) {
            return null;
        }
    };
    private final String myPath;
    private final NullableLazyValue<Icon> myIcon;

    public PathReference(@NotNull String path, final @NotNull Function<PathReference, Icon> icon) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/paths/PathReference.<init> must not be null");
        }
        if (icon == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/paths/PathReference.<init> must not be null");
        }
        this.myPath = path;
        this.myIcon = new NullableLazyValue<Icon>(){

            @Override
            protected Icon compute() {
                return (Icon)icon.fun(PathReference.this);
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/paths/PathReference.getPath must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getTrimmedPath() {
        String string = PathReference.trimPath(this.myPath);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/paths/PathReference.getTrimmedPath must not return null");
        }
        return string;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon.getValue();
    }

    @Nullable
    public PsiElement resolve() {
        return null;
    }

    public static String trimPath(String url) {
        for (int i = 0; i < url.length(); ++i) {
            switch (url.charAt(i)) {
                case '#': 
                case '?': {
                    return url.substring(0, i);
                }
            }
        }
        return url;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResolveFunction
    implements NullableFunction<PathReference, Icon> {
        public static final ResolveFunction NULL_RESOLVE_FUNCTION = new ResolveFunction(null);
        private final Icon myDefaultIcon;

        public ResolveFunction(@Nullable Icon defaultValue) {
            this.myDefaultIcon = defaultValue;
        }

        @Override
        public Icon fun(PathReference pathReference) {
            PsiElement element = pathReference.resolve();
            return element == null ? this.myDefaultIcon : element.getIcon(2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ConstFunction
    implements Function<PathReference, Icon> {
        private Icon myValue;

        public ConstFunction(Icon value) {
            this.myValue = value;
        }

        @Override
        public Icon fun(PathReference webPath) {
            return this.myValue;
        }
    }
}

