/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorListener;
import com.intellij.openapi.util.Disposer;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SettingsEditorConfigurable<Settings>
extends BaseConfigurable {
    private SettingsEditor<Settings> myEditor;
    private Settings mySettings;
    private SettingsEditorListener<Settings> myListener;
    private JComponent myComponent;

    public SettingsEditorConfigurable(SettingsEditor<Settings> editor, Settings settings) {
        this.myEditor = editor;
        this.mySettings = settings;
        this.myListener = new SettingsEditorListener<Settings>(){

            @Override
            public void stateChanged(SettingsEditor<Settings> settingsEditor) {
                SettingsEditorConfigurable.this.setModified(true);
            }
        };
        this.myEditor.addSettingsEditorListener(this.myListener);
        this.myComponent = this.myEditor.getComponent();
    }

    @Override
    public JComponent createComponent() {
        return this.myComponent;
    }

    @Override
    public void apply() throws ConfigurationException {
        this.myEditor.applyTo(this.mySettings);
        this.setModified(false);
    }

    @Override
    public void reset() {
        this.myEditor.resetFrom(this.mySettings);
        this.setModified(false);
    }

    @Override
    public void disposeUIResources() {
        this.myEditor.removeSettingsEditorListener(this.myListener);
        Disposer.dispose(this.myEditor);
        this.myEditor = null;
    }

    public SettingsEditor<Settings> getEditor() {
        return this.myEditor;
    }

    public Settings getSettings() {
        return this.mySettings;
    }
}

