/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.CompositeSettingsEditor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditorListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SettingsEditor<Settings>
implements Disposable {
    private List<SettingsEditorListener<Settings>> myListeners;
    private UserActivityWatcher myWatcher;
    private UserActivityListener myUserActivityListener;
    private boolean myIsInUpdate = false;
    private Factory<Settings> mySettingsFactory;
    private CompositeSettingsEditor<Settings> myOwner;
    private JComponent myEditorComponent;

    protected abstract void resetEditorFrom(Settings var1);

    protected abstract void applyEditorTo(Settings var1) throws ConfigurationException;

    @NotNull
    protected abstract JComponent createEditor();

    protected abstract void disposeEditor();

    public SettingsEditor() {
        this(null);
    }

    public SettingsEditor(Factory<Settings> settingsFactory) {
        this.mySettingsFactory = settingsFactory;
        Disposer.register(this, new Disposable(){

            public void dispose() {
                SettingsEditor.this.disposeEditor();
                SettingsEditor.this.uninstallWatcher();
            }
        });
    }

    public Settings getSnapshot() throws ConfigurationException {
        if (this.myOwner != null) {
            return this.myOwner.getSnapshot();
        }
        Settings settings = this.mySettingsFactory.create();
        this.applyTo(settings);
        return settings;
    }

    final void setOwner(CompositeSettingsEditor<Settings> owner) {
        this.myOwner = owner;
    }

    public final CompositeSettingsEditor<Settings> getOwner() {
        return this.myOwner;
    }

    public Factory<Settings> getFactory() {
        return this.mySettingsFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resetFrom(Settings s) {
        this.myIsInUpdate = true;
        try {
            this.resetEditorFrom(s);
        }
        finally {
            this.myIsInUpdate = false;
        }
    }

    public final void applyTo(Settings s) throws ConfigurationException {
        this.applyEditorTo(s);
    }

    public final JComponent getComponent() {
        if (this.myEditorComponent == null) {
            this.myEditorComponent = this.createEditor();
            this.installWatcher(this.myEditorComponent);
        }
        return this.myEditorComponent;
    }

    @Override
    public final void dispose() {
    }

    protected void uninstallWatcher() {
        this.myWatcher = null;
    }

    protected void installWatcher(JComponent c) {
        this.myWatcher = new UserActivityWatcher();
        this.myWatcher.register(c);
        this.myUserActivityListener = new UserActivityListener(){

            public void stateChanged() {
                SettingsEditor.this.fireEditorStateChanged();
            }
        };
        this.myWatcher.addUserActivityListener(this.myUserActivityListener, this);
    }

    public final void addSettingsEditorListener(SettingsEditorListener<Settings> listener) {
        if (this.myListeners == null) {
            this.myListeners = new ArrayList<SettingsEditorListener<Settings>>();
        }
        this.myListeners.add(listener);
    }

    public final void removeSettingsEditorListener(SettingsEditorListener<Settings> listener) {
        if (this.myListeners == null) {
            return;
        }
        this.myListeners.remove(listener);
        if (this.myListeners.size() == 0) {
            this.myListeners = null;
        }
    }

    protected final void fireEditorStateChanged() {
        if (this.myIsInUpdate || this.myListeners == null) {
            return;
        }
        SettingsEditorListener[] listeners = this.myListeners.toArray(new SettingsEditorListener[this.myListeners.size()]);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].stateChanged(this);
        }
    }
}

