/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleCircularDependencyException;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.util.graph.Graph;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModuleManager {
    public static ModuleManager getInstance(Project project) {
        return project.getComponent(ModuleManager.class);
    }

    @NotNull
    public abstract Module newModule(@NotNull String var1);

    @NotNull
    public abstract Module newModule(@NotNull @NonNls String var1, @NotNull ModuleType var2);

    @NotNull
    public abstract Module loadModule(@NotNull String var1) throws InvalidDataException, IOException, JDOMException, ModuleWithNameAlreadyExists, ModuleCircularDependencyException;

    public abstract void disposeModule(@NotNull Module var1);

    @NotNull
    public abstract Module[] getModules();

    @Nullable
    public abstract Module findModuleByName(@NonNls @NotNull String var1);

    @NotNull
    public abstract Module[] getSortedModules();

    @NotNull
    public abstract Comparator<Module> moduleDependencyComparator();

    @NotNull
    public abstract List<Module> getModuleDependentModules(@NotNull Module var1);

    public abstract boolean isModuleDependent(@NotNull Module var1, @NotNull Module var2);

    @NotNull
    public abstract Graph<Module> moduleGraph();

    public abstract void addModuleListener(@NotNull ModuleListener var1);

    public abstract void addModuleListener(@NotNull ModuleListener var1, Disposable var2);

    public abstract void removeModuleListener(@NotNull ModuleListener var1);

    @NotNull
    public abstract ModifiableModuleModel getModifiableModel();

    @Nullable
    public abstract String[] getModuleGroupPath(@NotNull Module var1);
}

