/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.SystemInfo;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;

public class KeymapUtil {
    private static final Icon ourKeyboardShortcutIcon = IconLoader.getIcon("/general/keyboardShortcut.png");
    private static final Icon ourMouseShortcutIcon = IconLoader.getIcon("/general/mouseShortcut.png");
    @NonNls
    private static final String APPLE_LAF_AQUA_LOOK_AND_FEEL_CLASS_NAME = "apple.laf.AquaLookAndFeel";
    @NonNls
    private static final String GET_KEY_MODIFIERS_TEXT_METHOD = "getKeyModifiersText";
    @NonNls
    private static final String CANCEL_KEY_TEXT = "Cancel";
    @NonNls
    private static final String BREAK_KEY_TEXT = "Break";
    @NonNls
    private static final String SHIFT = "shift";
    @NonNls
    private static final String CONTROL = "control";
    @NonNls
    private static final String CTRL = "ctrl";
    @NonNls
    private static final String META = "meta";
    @NonNls
    private static final String ALT = "alt";
    @NonNls
    private static final String ALT_GRAPH = "altGraph";
    @NonNls
    private static final String BUTTON1 = "button1";
    @NonNls
    private static final String BUTTON2 = "button2";
    @NonNls
    private static final String BUTTON3 = "button3";
    @NonNls
    private static final String DOUBLE_CLICK = "doubleClick";

    public static String getShortcutText(Shortcut shortcut) {
        String s = "";
        if (shortcut instanceof KeyboardShortcut) {
            KeyboardShortcut keyboardShortcut = (KeyboardShortcut)shortcut;
            String acceleratorText = KeymapUtil.getKeystrokeText(keyboardShortcut.getFirstKeyStroke());
            if (acceleratorText.length() > 0) {
                s = acceleratorText;
            }
            if ((acceleratorText = KeymapUtil.getKeystrokeText(keyboardShortcut.getSecondKeyStroke())).length() > 0) {
                s = s + ", " + acceleratorText;
            }
        } else if (shortcut instanceof MouseShortcut) {
            MouseShortcut mouseShortcut = (MouseShortcut)shortcut;
            s = KeymapUtil.getMouseShortcutText(mouseShortcut.getButton(), mouseShortcut.getModifiers(), mouseShortcut.getClickCount());
        } else {
            throw new IllegalArgumentException("unknown shortcut class: " + shortcut);
        }
        return s;
    }

    public static Icon getShortcutIcon(Shortcut shortcut) {
        if (shortcut instanceof KeyboardShortcut) {
            return ourKeyboardShortcutIcon;
        }
        if (shortcut instanceof MouseShortcut) {
            return ourMouseShortcutIcon;
        }
        throw new IllegalArgumentException("unknown shortcut class: " + shortcut);
    }

    public static String getMouseShortcutText(int button, int modifiers, int clickCount) {
        int buttonNum;
        if (1 == button) {
            buttonNum = 1;
        } else if (2 == button) {
            buttonNum = 2;
        } else if (3 == button) {
            buttonNum = 3;
        } else if (-1 == button) {
            buttonNum = 0;
        } else {
            throw new IllegalStateException("unknown button: " + button);
        }
        if (clickCount == 1) {
            return KeyMapBundle.message("mouse.click.shortcut.text", KeymapUtil.getModifiersText(KeymapUtil.mapNewModifiers(modifiers)), buttonNum);
        }
        if (clickCount == 2) {
            return KeyMapBundle.message("mouse.double.click.shortcut.text", KeymapUtil.getModifiersText(KeymapUtil.mapNewModifiers(modifiers)), buttonNum);
        }
        throw new IllegalStateException("unknown clickCount: " + clickCount);
    }

    private static int mapNewModifiers(int modifiers) {
        if ((modifiers & 0x40) != 0) {
            modifiers |= 1;
        }
        if ((modifiers & 0x200) != 0) {
            modifiers |= 8;
        }
        if ((modifiers & 0x2000) != 0) {
            modifiers |= 0x20;
        }
        if ((modifiers & 0x80) != 0) {
            modifiers |= 2;
        }
        if ((modifiers & 0x100) != 0) {
            modifiers |= 4;
        }
        return modifiers;
    }

    public static String getKeystrokeText(KeyStroke accelerator) {
        String keyText;
        if (accelerator == null) {
            return "";
        }
        String acceleratorText = "";
        int modifiers = accelerator.getModifiers();
        if (modifiers > 0) {
            acceleratorText = KeymapUtil.getModifiersText(modifiers);
        }
        if (CANCEL_KEY_TEXT.equals(keyText = KeyEvent.getKeyText(accelerator.getKeyCode()))) {
            keyText = BREAK_KEY_TEXT;
        }
        acceleratorText = acceleratorText + keyText;
        return acceleratorText.trim();
    }

    private static String getModifiersText(int modifiers) {
        String keyModifiersText;
        block4: {
            if (SystemInfo.isMac) {
                try {
                    Class<?> appleLaf = Class.forName(APPLE_LAF_AQUA_LOOK_AND_FEEL_CLASS_NAME);
                    Method getModifiers = appleLaf.getMethod(GET_KEY_MODIFIERS_TEXT_METHOD, Integer.TYPE, Boolean.TYPE);
                    return (String)getModifiers.invoke(appleLaf, new Integer(modifiers), Boolean.FALSE);
                }
                catch (Exception e) {
                    if (!SystemInfo.isMacOSLeopard) break block4;
                    return KeymapUtil.getKeyModifiersTextForMacOSLeopard(modifiers);
                }
            }
        }
        if ((keyModifiersText = KeyEvent.getKeyModifiersText(modifiers)).length() > 0) {
            return keyModifiersText + "+";
        }
        return keyModifiersText;
    }

    public static String getFirstKeyboardShortcutText(AnAction action) {
        Shortcut[] shortcuts = action.getShortcutSet().getShortcuts();
        for (int i = 0; i < shortcuts.length; ++i) {
            Shortcut shortcut = shortcuts[i];
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            return KeymapUtil.getShortcutText(shortcut);
        }
        return "";
    }

    public static String getShortcutsText(Shortcut[] shortcuts) {
        if (shortcuts.length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < shortcuts.length; ++i) {
            Shortcut shortcut = shortcuts[i];
            if (i > 0) {
                buffer.append(' ');
            }
            buffer.append(KeymapUtil.getShortcutText(shortcut));
        }
        return buffer.toString();
    }

    public static MouseShortcut parseMouseShortcut(String keystrokeString) throws InvalidDataException {
        int button = -1;
        int modifiers = 0;
        int clickCount = 1;
        StringTokenizer tokenizer = new StringTokenizer(keystrokeString);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (SHIFT.equals(token)) {
                modifiers |= 0x40;
                continue;
            }
            if (CONTROL.equals(token) || CTRL.equals(token)) {
                modifiers |= 0x80;
                continue;
            }
            if (META.equals(token)) {
                modifiers |= 0x100;
                continue;
            }
            if (ALT.equals(token)) {
                modifiers |= 0x200;
                continue;
            }
            if (ALT_GRAPH.equals(token)) {
                modifiers |= 0x2000;
                continue;
            }
            if (BUTTON1.equals(token)) {
                button = 1;
                continue;
            }
            if (BUTTON2.equals(token)) {
                button = 2;
                continue;
            }
            if (BUTTON3.equals(token)) {
                button = 3;
                continue;
            }
            if (DOUBLE_CLICK.equals(token)) {
                clickCount = 2;
                continue;
            }
            throw new InvalidDataException("unknown token: " + token);
        }
        return new MouseShortcut(button, modifiers, clickCount);
    }

    public static String getKeyModifiersTextForMacOSLeopard(int modifiers) {
        StringBuffer buf = new StringBuffer();
        if ((modifiers & 4) != 0) {
            buf.append(Toolkit.getProperty("AWT.meta", "Meta"));
        }
        if ((modifiers & 2) != 0) {
            buf.append(Toolkit.getProperty("AWT.control", "Ctrl"));
        }
        if ((modifiers & 8) != 0) {
            buf.append(Toolkit.getProperty("AWT.alt", "Alt"));
        }
        if ((modifiers & 1) != 0) {
            buf.append(Toolkit.getProperty("AWT.shift", "Shift"));
        }
        if ((modifiers & 0x20) != 0) {
            buf.append(Toolkit.getProperty("AWT.altGraph", "Alt Graph"));
        }
        if ((modifiers & 0x10) != 0) {
            buf.append(Toolkit.getProperty("AWT.button1", "Button1"));
        }
        return buf.toString();
    }
}

