/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.util;

import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.actions.ActualZoomAction;
import com.intellij.openapi.graph.builder.actions.DeleteSelectionAction;
import com.intellij.openapi.graph.builder.actions.FitContentAction;
import com.intellij.openapi.graph.builder.actions.ShowHideGridAction;
import com.intellij.openapi.graph.builder.actions.SnapToGridAction;
import com.intellij.openapi.graph.builder.actions.ZoomInAction;
import com.intellij.openapi.graph.builder.actions.ZoomOutAction;
import com.intellij.openapi.graph.builder.actions.export.ExportToFileAction;
import com.intellij.openapi.graph.builder.actions.layout.ApplyCurrentLayoutAction;
import com.intellij.openapi.graph.builder.actions.printing.PrintGraphAction;
import com.intellij.openapi.graph.builder.actions.printing.PrintPreviewAction;
import com.intellij.openapi.graph.builder.util.CompositeDataProvider;
import com.intellij.openapi.graph.view.GenericNodeRealizer;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeCellRenderer;
import com.intellij.openapi.graph.view.NodeCellRendererPainter;
import com.intellij.openapi.graph.view.NodeLabel;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.Overview;
import com.intellij.openapi.graph.view.hierarchy.GroupNodeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphViewUtil {
    @NonNls
    public static String GRAPH_KEY = "GRAPH_KEY";

    @Nullable
    public static Object getData(Graph2DView view, String data) {
        DataProvider dataProvider = (DataProvider)view.getJComponent().getClientProperty("DataProvider");
        if (dataProvider == null) {
            return null;
        }
        return dataProvider.getData(data);
    }

    public static Graph2DView createView(DataProvider dataProvider) {
        Graph2DView graph2DView = GraphManager.getGraphManager().createGraph2DView();
        GraphViewUtil.addDataProvider(graph2DView, dataProvider);
        return graph2DView;
    }

    public static void addDataProvider(Graph2DView graph2DView, @NotNull DataProvider dataProvider) {
        CompositeDataProvider compositeDataProvider;
        if (dataProvider == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/graph/builder/util/GraphViewUtil.addDataProvider must not be null");
        }
        DataProvider oldDataProvider = (DataProvider)graph2DView.getJComponent().getClientProperty("DataProvider");
        if (oldDataProvider == null) {
            compositeDataProvider = new CompositeDataProvider();
            compositeDataProvider.add(GraphViewUtil.createDefaultGraphDataProvider(graph2DView));
        } else if (oldDataProvider instanceof CompositeDataProvider) {
            compositeDataProvider = (CompositeDataProvider)oldDataProvider;
        } else {
            compositeDataProvider = new CompositeDataProvider();
            compositeDataProvider.add(oldDataProvider);
        }
        compositeDataProvider.add(dataProvider);
        graph2DView.getJComponent().putClientProperty("DataProvider", compositeDataProvider);
    }

    private static DataProvider createDefaultGraphDataProvider(final Graph2DView graph2DView) {
        return new DataProvider(){

            @Nullable
            public Object getData(@NonNls String dataId) {
                if (GRAPH_KEY.equals(dataId)) {
                    return graph2DView.getGraph2D();
                }
                return null;
            }
        };
    }

    public static List<Node> getSelectedNodes(final Graph2D graph) {
        return ContainerUtil.findAll(graph.getNodeArray(), new Condition<Node>(){

            @Override
            public boolean value(Node node) {
                return graph.getRealizer(node).isSelected();
            }
        });
    }

    public static List<Edge> getSelectedEdges(final Graph2D graph) {
        return ContainerUtil.findAll(graph.getEdgeArray(), new Condition<Edge>(){

            @Override
            public boolean value(Edge edge) {
                return graph.getRealizer(edge).isSelected();
            }
        });
    }

    public static NodeRealizer createNodeRealizer(@NonNls String configuration, NodeCellRenderer nodeCellRenderer) {
        GenericNodeRealizer nodeRealizer = GraphManager.getGraphManager().createGenericNodeRealizer();
        GenericNodeRealizer.Factory factory = GenericNodeRealizer.Statics.getFactory();
        Map map = factory.createDefaultConfigurationMap();
        map.put(GenericNodeRealizer.Painter.class, GraphManager.getGraphManager().createNodeCellRendererPainter(nodeCellRenderer, NodeCellRendererPainter.USER_DATA_MAP));
        factory.addConfiguration(configuration, map);
        nodeRealizer.setConfiguration(configuration);
        nodeRealizer.setUserData(nodeCellRenderer);
        return nodeRealizer;
    }

    public static void setRenderedNodeSizes(Graph2D graph, Graph2DView view, Node node) {
        NodeLabel nodeLabel;
        GroupNodeRealizer groupNodeRealizer;
        GenericNodeRealizer realizer;
        Object o;
        NodeRealizer nodeRealizer = graph.getRealizer(node);
        if (nodeRealizer instanceof GenericNodeRealizer && (o = (realizer = (GenericNodeRealizer)nodeRealizer).getUserData()) instanceof NodeCellRenderer) {
            Dimension size = ((NodeCellRenderer)o).getNodeCellRendererComponent(view, nodeRealizer, null, false).getPreferredSize();
            graph.setSize(nodeRealizer.getNode(), GraphManager.getGraphManager().createYDimension(size.width, size.height));
        }
        if (nodeRealizer instanceof GroupNodeRealizer && (groupNodeRealizer = (GroupNodeRealizer)nodeRealizer).isGroupClosed() && (nodeLabel = groupNodeRealizer.getLabel()) != null) {
            graph.setSize(node, nodeLabel.getWidth(), groupNodeRealizer.getHeight());
        }
    }

    public static JComponent createCommonToolbarPane(Graph2D graph) {
        DefaultActionGroup actions = GraphViewUtil.getBasicToolbar(graph);
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("unknown", actions, true);
        return actionToolbar.getComponent();
    }

    public static DefaultActionGroup getBasicToolbar(Graph2D graph) {
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add(new ShowHideGridAction(graph));
        actions.add(new SnapToGridAction(graph));
        actions.addSeparator();
        actions.add(new ZoomInAction(graph));
        actions.add(new ZoomOutAction(graph));
        actions.add(new ActualZoomAction(graph));
        actions.add(new FitContentAction(graph));
        actions.addSeparator();
        actions.add(new ApplyCurrentLayoutAction(graph));
        actions.addSeparator();
        actions.add(new ExportToFileAction(graph));
        actions.add(new PrintGraphAction(graph));
        actions.add(new PrintPreviewAction(graph));
        actions.addSeparator();
        actions.add(new DeleteSelectionAction());
        return actions;
    }

    public static AnAction getCommonPopupActions() {
        return ActionManager.getInstance().getAction("Graph.DefaultGraphPopup");
    }

    public static void updateWorldRect(Graph2DView view) {
        Rectangle rectangle = GraphViewUtil.getActualSize(view);
        int x = (int)rectangle.getX() - 20;
        int y = (int)rectangle.getY() - 20;
        int width = (int)rectangle.getWidth() + 40;
        int hight = (int)rectangle.getHeight() + 40;
        view.setWorldRect(x, y, width, hight);
    }

    public static Rectangle getActualSize(Graph2DView view) {
        return view.getGraph2D().getBoundingBox();
    }

    public static StructureViewBuilder createStructureViewBuilder(final Overview overview) {
        return new StructureViewBuilder(){

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public StructureView createStructureView(final FileEditor fileEditor, Project project) {
                StructureView structureView = new StructureView(){

                    public FileEditor getFileEditor() {
                        return fileEditor;
                    }

                    public boolean navigateToSelectedElement(boolean requestFocus) {
                        return false;
                    }

                    public JComponent getComponent() {
                        return overview.getJComponent();
                    }

                    public void dispose() {
                    }

                    public void centerSelectedRow() {
                    }

                    public void restoreState() {
                    }

                    public void storeState() {
                    }
                };
                if (structureView == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/openapi/graph/builder/util/GraphViewUtil$4.createStructureView must not return null");
                }
                return structureView;
            }
        };
    }
}

