/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.renderer;

import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeCellRenderer;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicNodeCellRenderer
implements NodeCellRenderer {
    private final Map<Pair<NodeRealizer, Boolean>, JComponent> myData = new HashMap<Pair<NodeRealizer, Boolean>, JComponent>();
    private final ModificationTracker myModificationTracker;
    private long myModificationCount = 0L;

    protected BasicNodeCellRenderer(ModificationTracker modificationTracker) {
        this.myModificationTracker = modificationTracker;
    }

    @Override
    public JComponent getNodeCellRendererComponent(Graph2DView graph2DView, NodeRealizer nodeRealizer, Object object, boolean b) {
        Pair<NodeRealizer, Boolean> key = Pair.create(nodeRealizer, b);
        Map<Pair<NodeRealizer, Boolean>, JComponent> map = this.getData();
        JComponent component = map.get(key);
        if (component == null) {
            component = this.getRendererComponent(graph2DView, nodeRealizer, object, b);
            map.put(key, component);
        }
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)component, "Center");
        return wrapper;
    }

    private Map<Pair<NodeRealizer, Boolean>, JComponent> getData() {
        if (this.myModificationTracker == null) {
            this.clearCache();
        } else if (this.myModificationCount != this.myModificationTracker.getModificationCount()) {
            this.clearCache();
            this.myModificationCount = this.myModificationTracker.getModificationCount();
        }
        return this.myData;
    }

    protected void clearCache() {
        this.myData.clear();
    }

    protected abstract JComponent getRendererComponent(Graph2DView var1, NodeRealizer var2, Object var3, boolean var4);
}

