/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.renderer;

import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.renderer.AbstractColoredNodeCellRenderer;
import com.intellij.openapi.graph.builder.renderer.GradientFilledPanel;
import com.intellij.openapi.graph.builder.util.GraphWrapperUtil;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.ui.LightColors;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicGraphNodeRenderer<N>
extends AbstractColoredNodeCellRenderer {
    protected static final Icon DEFAULT_ICON = IconLoader.getIcon("/fileTypes/unknown.png");
    private final GraphWrapperUtil myWrapper;

    public BasicGraphNodeRenderer(Project project, ModificationTracker modificationTracker) {
        super(modificationTracker);
        this.myWrapper = GraphWrapperUtil.getInstance(project);
    }

    @Override
    public void tuneNode(NodeRealizer nodeRealizer, JPanel wrapper) {
        wrapper.removeAll();
        wrapper.setLayout(new BorderLayout());
        Node node = nodeRealizer.getNode();
        Object object = this.myWrapper.getNodeObject(node.getGraph(), node);
        wrapper.add((Component)this.getIconLabel(object), "West");
        wrapper.add((Component)this.getLabelPanel(nodeRealizer), "Center");
    }

    protected JComponent getLabelPanel(NodeRealizer nodeRealizer) {
        Node node = nodeRealizer.getNode();
        Object object = this.myWrapper.getNodeObject(node.getGraph(), node);
        GradientFilledPanel jPanel = new GradientFilledPanel(this.getBackground(object));
        jPanel.setBorder(BorderFactory.createLineBorder(Color.WHITE, 2));
        jPanel.setBackground(LightColors.BLUE);
        jPanel.setLayout(new BorderLayout());
        String text = this.getNodeName(object);
        JLabel comp = new JLabel(text);
        comp.setForeground(this.getForeground(object));
        comp.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        jPanel.add((Component)comp, "West");
        return jPanel;
    }

    protected Color getForeground(N node) {
        return Color.BLACK;
    }

    protected Color getBackground(N node) {
        return LightColors.BLUE;
    }

    protected Icon getIcon(N node) {
        return DEFAULT_ICON;
    }

    protected JComponent getIconLabel(N node) {
        JLabel jLabel = new JLabel(this.getIcon(node));
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return jLabel;
    }

    protected String getNodeName(N node) {
        return "";
    }
}

