/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.renderer;

import com.intellij.openapi.graph.builder.renderer.BasicNodeCellRenderer;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.ui.components.panels.NonOpaquePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

public abstract class AbstractColoredNodeCellRenderer
extends BasicNodeCellRenderer {
    private static final Color BORDER_COLOR = Color.LIGHT_GRAY;
    private static final Color SHADOW_BORDER_COLOR = Color.GRAY;

    protected AbstractColoredNodeCellRenderer(ModificationTracker modificationTracker) {
        super(modificationTracker);
    }

    protected JComponent getRendererComponent(Graph2DView graph2DView, NodeRealizer nodeRealizer, Object object, boolean sel) {
        JPanel innerPanel = new JPanel(new BorderLayout());
        NonOpaquePanel outerPanel = new NonOpaquePanel(innerPanel);
        outerPanel.setBorder(sel ? new LineBorder(this.getSelectionColor(), this.getSelectionBorderWidth(), true) : new ShadowedLineBorder());
        innerPanel.setBorder(sel ? new LineBorder(Color.ORANGE) : new LineBorder(Color.LIGHT_GRAY));
        this.tuneNode(nodeRealizer, innerPanel);
        return outerPanel;
    }

    public abstract void tuneNode(NodeRealizer var1, JPanel var2);

    protected int getSelectionBorderWidth() {
        return 1;
    }

    protected Color getSelectionColor() {
        return Color.ORANGE;
    }

    public class ShadowedLineBorder
    extends LineBorder {
        public ShadowedLineBorder() {
            super(BORDER_COLOR, AbstractColoredNodeCellRenderer.this.getSelectionBorderWidth());
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color oldColor = g.getColor();
            g.setColor(SHADOW_BORDER_COLOR);
            int selectionBorderWidth = AbstractColoredNodeCellRenderer.this.getSelectionBorderWidth();
            g.fillRect(x + 2 * selectionBorderWidth, y + height - selectionBorderWidth, width - 2 * selectionBorderWidth, selectionBorderWidth);
            g.fillRect(x + width - selectionBorderWidth, y + 2 * selectionBorderWidth, selectionBorderWidth, height - 2 * selectionBorderWidth);
            g.setColor(oldColor);
        }
    }
}

