/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.components;

import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.graph.view.hierarchy.GroupNodeRealizer;
import com.intellij.util.Icons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicNodesGroup
extends NodesGroup {
    private String myGroupName;
    private NodesGroup myParent;
    private boolean myClosed;

    public BasicNodesGroup(@NotNull String groupName) {
        if (groupName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/graph/builder/components/BasicNodesGroup.<init> must not be null");
        }
        this(groupName, null);
    }

    public BasicNodesGroup(String groupName, NodesGroup parent) {
        this.myGroupName = groupName;
        this.myParent = parent;
        this.myClosed = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getGroupName() {
        String string = this.myGroupName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/graph/builder/components/BasicNodesGroup.getGroupName must not return null");
        }
        return string;
    }

    @Nullable
    public GroupNodeRealizer getGroupNodeRealizer() {
        GroupNodeRealizer groupNodeRealizer = GraphManager.getGraphManager().createGroupNodeRealizer();
        groupNodeRealizer.setInnerGraphDisplayEnabled(true);
        groupNodeRealizer.setAutoBoundsEnabled(true);
        groupNodeRealizer.setLabelText(this.getGroupName());
        groupNodeRealizer.setOpenGroupIcon(Icons.PACKAGE_OPEN_ICON);
        groupNodeRealizer.setClosedGroupIcon(Icons.PACKAGE_ICON);
        return groupNodeRealizer;
    }

    public boolean isClosed() {
        return this.myClosed;
    }

    public void setClosed(boolean closed) {
        this.myClosed = closed;
    }

    @Nullable
    public NodesGroup getParent() {
        return this.myParent;
    }

    public void setParent(NodesGroup parent) {
        this.myParent = parent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicNodesGroup that = (BasicNodesGroup)o;
        return this.myGroupName.equals(that.myGroupName);
    }

    public int hashCode() {
        return 31 * super.hashCode() + this.myGroupName.hashCode();
    }
}

