/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.components;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.util.Disposer;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicGraphComponent<N, E>
implements Disposable {
    private final JComponent myComponent;
    private final GraphBuilder<N, E> myBuilder;

    public BasicGraphComponent(@NotNull GraphBuilder<N, E> builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/graph/builder/components/BasicGraphComponent.<init> must not be null");
        }
        this.myBuilder = builder;
        this.myComponent = new JPanel(new BorderLayout());
        this.myComponent.add((Component)GraphViewUtil.createCommonToolbarPane(builder.getGraph()), "North");
        this.myComponent.add(builder.getView().getComponent(), "Center");
        Disposer.register(this, builder);
        builder.initialize();
    }

    @Override
    public void dispose() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/graph/builder/components/BasicGraphComponent.getComponent must not return null");
        }
        return jComponent;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public GraphBuilder<N, E> getBuilder() {
        GraphBuilder<N, E> graphBuilder = this.myBuilder;
        if (graphBuilder == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/graph/builder/components/BasicGraphComponent.getBuilder must not return null");
        }
        return graphBuilder;
    }
}

