/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions.printing;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.builder.actions.printing.Graph2DPrintPreviewPanel;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.PrintPreviewPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.IconLoader;
import java.awt.print.PrinterJob;

public class PrintPreviewAction
extends AbstractGraphAction {
    public PrintPreviewAction() {
    }

    public PrintPreviewAction(Graph2D graph2D) {
        super(graph2D);
    }

    private PrintPreviewPanel createPanel(Graph2D graph2D) {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        Graph2DView view = PrintPreviewAction.getGraph2DView(graph2D);
        return Graph2DPrintPreviewPanel.createPanel(printJob, GraphManager.getGraphManager().createGraph2DPrinter(view), printJob.defaultPage());
    }

    public void actionPerformed(AnActionEvent e, Graph2D graph2D) {
        Project project = PrintPreviewAction.getProject(e);
        if (project == null) {
            return;
        }
        DialogBuilder builder = new DialogBuilder(project);
        builder.setCenterPanel(this.createPanel(graph2D).getJPanel());
        builder.setTitle(ActionsBundle.message("action.Graph.print.preview", new Object[0]));
        builder.show();
    }

    public void update(AnActionEvent e, Graph2D graph2D) {
        e.getPresentation().setText(ActionsBundle.message("action.Graph.print.preview", new Object[0]));
        e.getPresentation().setIcon(IconLoader.getIcon("/graph/printPreview.png"));
    }
}

