/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions.printing;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.builder.actions.printing.PrintUtil;
import com.intellij.openapi.graph.option.OptionHandler;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DPrinter;
import com.intellij.openapi.util.IconLoader;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;

public class PrintGraphAction
extends AbstractGraphAction {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.graph.builder.actions.printing.PrintGraphAction");
    private PageFormat myPageFormat;

    public PrintGraphAction() {
    }

    public PrintGraphAction(Graph2D graph2D) {
        super(graph2D);
    }

    public void actionPerformed(AnActionEvent e, Graph2D graph2D) {
        PageFormat pf;
        Graph2DPrinter gprinter = GraphManager.getGraphManager().createGraph2DPrinter(PrintGraphAction.getGraph2DView(graph2D));
        OptionHandler handler = PrintUtil.createPrintOptions();
        if (!handler.showEditor()) {
            return;
        }
        PrintUtil.initGraph2DPrinter(gprinter, handler);
        PrinterJob printJob = PrinterJob.getPrinterJob();
        if (this.myPageFormat == null) {
            this.myPageFormat = printJob.defaultPage();
        }
        if ((pf = printJob.pageDialog(this.myPageFormat)) == this.myPageFormat) {
            return;
        }
        this.myPageFormat = pf;
        printJob.setPrintable(gprinter, this.myPageFormat);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (Exception ex) {
                LOG.error(ex);
            }
        }
    }

    public void update(AnActionEvent e, Graph2D graph2D) {
        e.getPresentation().setText(ActionsBundle.message("action.Graph.print", new Object[0]));
        e.getPresentation().setIcon(IconLoader.getIcon("/graph/print.png"));
    }
}

