/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions.export;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.builder.actions.export.SaveGraphToImageDialog;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashMap;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ExportToFileAction
extends AbstractGraphAction {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.graph.builder.actions.export.ExportToFileAction");
    @NonNls
    private static final String DEFAULT_FILE_NAME = "graph_img";
    private static Map<String, String> myExtensions = new HashMap<String, String>();

    public ExportToFileAction() {
    }

    public ExportToFileAction(Graph2D graph) {
        super(graph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(AnActionEvent e, Graph2D graph) {
        Project project = ExportToFileAction.getProject(e);
        if (project == null) {
            return;
        }
        String path = ExportToFileAction.choosePath(project, ExportToFileAction.getVirtualFile(e));
        if (path == null) {
            return;
        }
        String extension = path.substring(path.lastIndexOf(".") + 1).trim();
        if (!myExtensions.containsKey(extension)) {
            return;
        }
        Graph2DView originalView = (Graph2DView)graph.getCurrentView();
        Point2D originalViewPoint2D = originalView.getViewPoint2D();
        JComponent component = ExportToFileAction.tuneGraph2DView(originalView);
        FileOutputStream os = null;
        try {
            BufferedImage bi = new BufferedImage(component.getWidth(), component.getHeight(), 1);
            component.paint(bi.getGraphics());
            os = new FileOutputStream(path);
            ImageIO.write((RenderedImage)bi, extension, os);
        }
        catch (Exception ex) {
            LOG.error(ex);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e1) {
                LOG.error(e1);
            }
            originalView.setViewPoint2D(originalViewPoint2D.getX(), originalViewPoint2D.getY());
        }
    }

    private static JComponent tuneGraph2DView(Graph2DView originalView) {
        Rectangle box = originalView.getGraph2D().getBoundingBox();
        GraphViewUtil.updateWorldRect(originalView);
        originalView.setViewPoint2D(box.getX() - 20.0, box.getY() - 20.0);
        JComponent component = originalView.getCanvasComponent();
        component.setBounds(0, 0, (int)box.getWidth() + 40, (int)box.getHeight() + 40);
        return component;
    }

    @Nullable
    private static String choosePath(Project project, @Nullable VirtualFile virtualFile) {
        VirtualFile directory = virtualFile == null ? null : virtualFile.getParent();
        SaveGraphToImageDialog dialog = new SaveGraphToImageDialog(project, directory, DEFAULT_FILE_NAME, myExtensions.keySet());
        dialog.show();
        if (!dialog.isOK()) {
            return null;
        }
        return dialog.getPath();
    }

    @Nullable
    protected static VirtualFile getVirtualFile(AnActionEvent e) {
        return DataKeys.VIRTUAL_FILE.getData(e.getDataContext());
    }

    public void update(AnActionEvent e, Graph2D graph) {
        e.getPresentation().setEnabled(true);
        e.getPresentation().setVisible(true);
        e.getPresentation().setIcon(IconLoader.getIcon("/graph/export.png"));
        e.getPresentation().setText(ActionsBundle.message("action.Graph.export.to.file", new Object[0]));
    }

    static {
        myExtensions.put("png", "png");
        myExtensions.put("jpeg", "jpeg");
        myExtensions.put("gif", "gif");
    }
}

