/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import javax.swing.Icon;

public abstract class ZoomAction
extends AbstractGraphAction {
    private double myScale = 0.0;

    protected ZoomAction() {
    }

    protected ZoomAction(double scale) {
        this.myScale = scale;
    }

    protected ZoomAction(Graph2D graph, double scale) {
        super(graph);
        this.myScale = scale;
    }

    public void actionPerformed(AnActionEvent e, Graph2D graph) {
        Graph2DView graph2DView = ZoomAction.getGraph2DView(graph);
        graph2DView.setZoom(graph2DView.getZoom() + this.myScale);
    }

    public void update(AnActionEvent e, Graph2D graph) {
        e.getPresentation().setEnabled(ZoomAction.getGraph2DView(graph).getZoom() + this.getScale() > 0.1);
        e.getPresentation().setVisible(true);
        e.getPresentation().setIcon(this.getIcon());
        e.getPresentation().setText(this.getText());
    }

    protected abstract Icon getIcon();

    protected abstract String getText();

    public double getScale() {
        return this.myScale;
    }

    protected void setScale(double scale) {
        this.myScale = scale;
    }
}

