/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.graph.builder.actions.AbstractGraphToggleAction;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ShowHideGridAction
extends AbstractGraphToggleAction {
    private static final Icon ICON = IconLoader.getIcon("/graph/grid.png");

    public ShowHideGridAction() {
        super(ICON);
    }

    public ShowHideGridAction(Graph2D graph) {
        super(graph, ICON);
    }

    protected boolean isSelected(Graph2D graph, Project project, AnActionEvent event) {
        Graph2DView view = (Graph2DView)graph.getCurrentView();
        return view.isGridVisible();
    }

    protected void setSelected(Graph2D graph, boolean state, Project project, AnActionEvent e) {
        Graph2DView view = (Graph2DView)graph.getCurrentView();
        view.setGridVisible(state);
        view.updateView();
    }

    protected String getText(@NotNull Graph2D graph) {
        if (graph == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/graph/builder/actions/ShowHideGridAction.getText must not be null");
        }
        return ((Graph2DView)graph.getCurrentView()).isGridVisible() ? ActionsBundle.message("action.Graph.grid.hide", new Object[0]) : ActionsBundle.message("action.Graph.grid.show", new Object[0]);
    }
}

