/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.EdgeCursor;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeCursor;
import com.intellij.openapi.graph.builder.DeleteProvider;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphBundle;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.Icons;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteSelectionAction
extends AbstractGraphAction {
    protected void actionPerformed(AnActionEvent e, Graph2D graph) {
        DeleteProvider deleteProvider = DeleteSelectionAction.getDeleteProvider(e);
        GraphBuilder graphBuilder = DeleteSelectionAction.getGraphBuilder(e);
        if (deleteProvider == null || graphBuilder == null) {
            return;
        }
        List<Node> nodesToBeDeleted = DeleteSelectionAction.getNodesToBeDeleted(graph, graphBuilder, deleteProvider);
        List<Edge> edgesToBeDeleted = DeleteSelectionAction.getEdgesToBeDeleted(graph, graphBuilder, deleteProvider);
        if (nodesToBeDeleted.size() > 0 || edgesToBeDeleted.size() > 0) {
            String messageCaption;
            String messageText = GraphBundle.message("graph.delete.message", new Object[0]) + "?";
            if (0 == Messages.showOkCancelDialog(messageText, messageCaption = GraphBundle.message("graph.delete.message.caption", new Object[0]), Messages.getQuestionIcon())) {
                for (Node node : nodesToBeDeleted) {
                    Object nodeObject = graphBuilder.getNodeObject(node);
                    if (nodeObject == null) continue;
                    deleteProvider.deleteNode(nodeObject);
                }
                for (Edge edge : edgesToBeDeleted) {
                    Object edgeObject = graphBuilder.getEdgeObject(edge);
                    if (edgeObject == null) continue;
                    deleteProvider.deleteEdge(edgeObject);
                }
            }
            graphBuilder.updateGraph();
        }
    }

    protected void update(AnActionEvent e, Graph2D graph) {
        DeleteProvider deleteProvider = DeleteSelectionAction.getDeleteProvider(e);
        GraphBuilder graphBuilder = DeleteSelectionAction.getGraphBuilder(e);
        boolean enabled = false;
        if (deleteProvider == null || graphBuilder == null) {
            e.getPresentation().setVisible(false);
        } else {
            List<Node> toBeDeleted = DeleteSelectionAction.getNodesToBeDeleted(graph, graphBuilder, deleteProvider);
            List<Edge> edgesToBeDeleted = DeleteSelectionAction.getEdgesToBeDeleted(graph, graphBuilder, deleteProvider);
            enabled = toBeDeleted.size() > 0 || edgesToBeDeleted.size() > 0;
        }
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setText(GraphBundle.message("graph.delete.message", new Object[0]));
        e.getPresentation().setIcon(Icons.DELETE_ICON);
    }

    private static List<Node> getNodesToBeDeleted(Graph2D graph, @NotNull GraphBuilder graphBuilder, @NotNull DeleteProvider deleteProvider) {
        if (graphBuilder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/graph/builder/actions/DeleteSelectionAction.getNodesToBeDeleted must not be null");
        }
        if (deleteProvider == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/graph/builder/actions/DeleteSelectionAction.getNodesToBeDeleted must not be null");
        }
        ArrayList<Node> toBeDeleted = new ArrayList<Node>();
        NodeCursor nc = graph.selectedNodes();
        while (nc.ok()) {
            Node node = nc.node();
            Object nodeObject = graphBuilder.getNodeObject(node);
            if (nodeObject != null && deleteProvider.canDeleteNode(nodeObject)) {
                toBeDeleted.add(node);
            }
            nc.next();
        }
        return toBeDeleted;
    }

    private static List<Edge> getEdgesToBeDeleted(Graph2D graph, GraphBuilder graphBuilder, DeleteProvider deleteProvider) {
        ArrayList<Edge> toBeDeleted = new ArrayList<Edge>();
        EdgeCursor edgeCursor = graph.selectedEdges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            Object edgeObject = graphBuilder.getEdgeObject(edge);
            if (edgeObject != null && deleteProvider.canDeleteEdge(edgeObject)) {
                toBeDeleted.add(edge);
            }
            edgeCursor.next();
        }
        return toBeDeleted;
    }

    @Nullable
    private static DeleteProvider getDeleteProvider(AnActionEvent e) {
        return (DeleteProvider)e.getDataContext().getData(DeleteProvider.GRAPH_DELETE_PROVIDER_KEY);
    }

    @Nullable
    private static GraphBuilder getGraphBuilder(AnActionEvent e) {
        return (GraphBuilder)e.getDataContext().getData(GraphBuilder.GRAPH_BUILDER_KEY);
    }
}

