/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder;

import com.intellij.openapi.graph.builder.GraphDataModel;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CachedGraphDataModel<N, E>
extends GraphDataModel<N, E> {
    private boolean myDirty = true;
    protected final Set<N> myNodes = new HashSet<N>();
    protected final Map<E, EdgeInfo<N>> myEdges = new HashMap<E, EdgeInfo<N>>();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Collection<N> getNodes() {
        this.checkUpdate();
        Set<N> set = this.myNodes;
        if (set == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/graph/builder/CachedGraphDataModel.getNodes must not return null");
        }
        return set;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Collection<E> getEdges() {
        this.checkUpdate();
        Set<E> set = this.myEdges.keySet();
        if (set == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/graph/builder/CachedGraphDataModel.getEdges must not return null");
        }
        return set;
    }

    @Override
    public N getSourceNode(E e) {
        EdgeInfo<N> info = this.myEdges.get(e);
        return info.source;
    }

    @Override
    public N getTargetNode(E e) {
        EdgeInfo<N> info = this.myEdges.get(e);
        return info.target;
    }

    @Override
    public E createEdge(@NotNull N from, @NotNull N to) {
        if (from == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/graph/builder/CachedGraphDataModel.createEdge must not be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/graph/builder/CachedGraphDataModel.createEdge must not be null");
        }
        return null;
    }

    @Override
    public void dispose() {
    }

    protected void createNode(N node) {
        this.myNodes.add(node);
    }

    protected void createEdge(E edge, N source, N target) {
        this.myEdges.put(edge, new EdgeInfo<N>(source, target));
    }

    protected final synchronized void checkUpdate() {
        if (this.myDirty) {
            this.buildGraph();
            this.myDirty = false;
        }
    }

    protected abstract void buildGraph();

    protected void clear() {
        this.myNodes.clear();
        this.myEdges.clear();
    }

    public final synchronized void setDirty() {
        this.myDirty = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class EdgeInfo<N> {
        final N source;
        final N target;

        EdgeInfo(N source, N target) {
            this.source = source;
            this.target = target;
        }
    }
}

