/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.base;

import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.DataProvider;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.EdgeCursor;
import com.intellij.openapi.graph.base.EdgeList;
import com.intellij.openapi.graph.base.EdgeMap;
import com.intellij.openapi.graph.base.GraphInterface;
import com.intellij.openapi.graph.base.GraphListener;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeCursor;
import com.intellij.openapi.graph.base.NodeList;
import com.intellij.openapi.graph.base.NodeMap;
import java.util.Comparator;
import java.util.Iterator;

public interface Graph
extends GraphInterface {
    public static final int BEFORE = GraphManager.getGraphManager()._Graph_BEFORE();
    public static final int AFTER = GraphManager.getGraphManager()._Graph_AFTER();

    public Graph createCopy();

    public Node createNode();

    public Edge createEdge(Node var1, Node var2);

    public Edge createEdge(Node var1, Edge var2, Node var3, Edge var4, int var5, int var6);

    public void removeNode(Node var1);

    public void removeEdge(Edge var1);

    public void reInsertNode(Node var1);

    public void reInsertEdge(Edge var1);

    public void changeEdge(Edge var1, Edge var2, Edge var3, int var4, int var5);

    public void changeEdge(Edge var1, Node var2, Edge var3, int var4, Node var5, Edge var6, int var7);

    public void changeEdge(Edge var1, Node var2, Node var3);

    public void reverseEdge(Edge var1);

    public void hide(Edge var1);

    public void unhide(Edge var1);

    public void hide(Node var1);

    public void unhide(Node var1);

    public void moveToLast(Node var1);

    public void moveToFirst(Node var1);

    public void moveToLast(Edge var1);

    public void moveToFirst(Edge var1);

    public int N();

    public int nodeCount();

    public int E();

    public int edgeCount();

    public boolean isEmpty();

    public void clear();

    public boolean contains(Node var1);

    public boolean contains(Edge var1);

    public boolean containsEdge(Node var1, Node var2);

    public Node firstNode();

    public Edge firstEdge();

    public Node lastNode();

    public Edge lastEdge();

    public Node[] getNodeArray();

    public Edge[] getEdgeArray();

    public NodeCursor nodes();

    public EdgeCursor edges();

    public EdgeList moveSubGraph(NodeList var1, Graph var2);

    public Graph createGraph();

    public void sortEdges(Comparator var1);

    public void sortNodes(Comparator var1);

    public void sortEdges(Comparator var1, Comparator var2);

    public void addGraphListener(GraphListener var1);

    public void removeGraphListener(GraphListener var1);

    public Iterator getGraphListeners();

    public void firePreEvent();

    public void firePreEvent(Object var1);

    public void firePostEvent();

    public void firePostEvent(Object var1);

    public NodeMap createNodeMap();

    public EdgeMap createEdgeMap();

    public void disposeNodeMap(NodeMap var1);

    public void disposeEdgeMap(EdgeMap var1);

    public NodeMap[] getRegisteredNodeMaps();

    public EdgeMap[] getRegisteredEdgeMaps();

    public Object getSource(Object var1);

    public Object getTarget(Object var1);

    public Iterator nodeObjects();

    public Iterator edgeObjects();

    public DataProvider getDataProvider(Object var1);

    public void addDataProvider(Object var1, DataProvider var2);

    public void removeDataProvider(Object var1);

    public Object[] getDataProviderKeys();

    public void printNodeSlotSize();

    public String toString();
}

