/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.util.PatternUtil;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class WildcardFileNameMatcher
implements FileNameMatcher {
    private final String myPattern;
    private final Matcher myMatcher;

    public WildcardFileNameMatcher(@NotNull @NonNls String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/WildcardFileNameMatcher.<init> must not be null");
        }
        this.myPattern = pattern;
        this.myMatcher = PatternUtil.fromMask(pattern).matcher("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean accept(String fileName) {
        Matcher matcher = this.myMatcher;
        synchronized (matcher) {
            this.myMatcher.reset(fileName);
            return this.myMatcher.matches();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNls
    @NotNull
    public String getPresentableString() {
        String string = this.myPattern;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/WildcardFileNameMatcher.getPresentableString must not return null");
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WildcardFileNameMatcher that = (WildcardFileNameMatcher)o;
        return this.myPattern.equals(that.myPattern);
    }

    public int hashCode() {
        return this.myPattern.hashCode();
    }

    public String getPattern() {
        return this.myPattern;
    }
}

