/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Icons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UserFileType<T extends UserFileType>
implements FileType,
Cloneable {
    @NotNull
    private String myName = "";
    private String myDescription = "";
    private Icon myIcon = Icons.CUSTOM_FILE_ICON;

    public abstract SettingsEditor<T> getEditor();

    public UserFileType clone() {
        try {
            return (UserFileType)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/UserFileType.getName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/UserFileType.getDescription must not return null");
        }
        return string;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/UserFileType.setName must not be null");
        }
        this.myName = name;
    }

    public void setDescription(String description) {
        this.myDescription = description;
    }

    @Override
    @NotNull
    public String getDefaultExtension() {
        if ("" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/UserFileType.getDefaultExtension must not return null");
        }
        return "";
    }

    @Override
    public Icon getIcon() {
        return this.myIcon;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getCharset(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/UserFileType.getCharset must not be null");
        }
        return null;
    }

    public void copyFrom(UserFileType newType) {
        this.myName = newType.getName();
        this.myDescription = newType.getDescription();
    }

    public void setIcon(Icon icon) {
        this.myIcon = icon;
    }

    @Override
    public StructureViewBuilder getStructureViewBuilder(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/UserFileType.getStructureViewBuilder must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileTypes/UserFileType.getStructureViewBuilder must not be null");
        }
        return null;
    }
}

