/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.peer.PeerFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LanguageFileType
implements FileType {
    private final Language myLanguage;

    protected LanguageFileType(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/LanguageFileType.<init> must not be null");
        }
        this.myLanguage = language;
        this.myLanguage.associateFileType(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Language getLanguage() {
        Language language = this.myLanguage;
        if (language == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/LanguageFileType.getLanguage must not return null");
        }
        return language;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public SyntaxHighlighter getHighlighter(@Nullable Project project, @Nullable VirtualFile virtualFile) {
        SyntaxHighlighter syntaxHighlighter = this.myLanguage.getSyntaxHighlighter(project, virtualFile);
        if (syntaxHighlighter == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/LanguageFileType.getHighlighter must not return null");
        }
        return syntaxHighlighter;
    }

    public EditorHighlighter getEditorHighlighter(@Nullable Project project, @Nullable VirtualFile virtualFile, @NotNull EditorColorsScheme colors) {
        if (colors == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/fileTypes/LanguageFileType.getEditorHighlighter must not be null");
        }
        return PeerFactory.getInstance().createEditorHighlighter(this.getHighlighter(project, virtualFile), colors);
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/LanguageFileType.getStructureViewBuilder must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileTypes/LanguageFileType.getStructureViewBuilder must not be null");
        }
        PsiFile psiFile = PsiManager.getInstance(project).findFile(file);
        return psiFile == null ? null : this.myLanguage.getStructureViewBuilder(psiFile);
    }

    public final boolean isBinary() {
        return false;
    }

    public final boolean isReadOnly() {
        return false;
    }

    public String getCharset(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/LanguageFileType.getCharset must not be null");
        }
        return null;
    }

    public boolean isJVMDebuggingSupported() {
        return false;
    }

    public Charset extractCharsetFromFileContent(@Nullable Project project, @NotNull VirtualFile file, @NotNull String content) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileTypes/LanguageFileType.extractCharsetFromFileContent must not be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/fileTypes/LanguageFileType.extractCharsetFromFileContent must not be null");
        }
        return null;
    }
}

