/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ExcactFileNameMatcher
implements FileNameMatcher {
    private final String myFileName;

    public ExcactFileNameMatcher(@NotNull @NonNls String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/ExcactFileNameMatcher.<init> must not be null");
        }
        this.myFileName = fileName;
    }

    public boolean accept(@NonNls @NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/ExcactFileNameMatcher.accept must not be null");
        }
        return Comparing.equal(fileName, this.myFileName, SystemInfo.isFileSystemCaseSensitive);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNls
    @NotNull
    public String getPresentableString() {
        String string = this.myFileName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/ExcactFileNameMatcher.getPresentableString must not return null");
        }
        return string;
    }

    public String getFileName() {
        return this.myFileName;
    }
}

