/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.TextEditor;

public class TextEditorLocation
implements FileEditorLocation {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.fileEditor.TextEditorLocation");
    private final TextEditor myEditor;
    private final LogicalPosition myPosition;

    public TextEditorLocation(int offset, TextEditor editor) {
        this(editor.getEditor().offsetToLogicalPosition(offset), editor);
    }

    public TextEditorLocation(LogicalPosition position, TextEditor editor) {
        this.myEditor = editor;
        this.myPosition = position;
    }

    public FileEditor getEditor() {
        return this.myEditor;
    }

    public LogicalPosition getPosition() {
        return this.myPosition;
    }

    public int compareTo(FileEditorLocation fileEditorLocation) {
        TextEditorLocation otherLocation = (TextEditorLocation)fileEditorLocation;
        LOG.assertTrue(this.myEditor == otherLocation.myEditor);
        return this.myPosition.compareTo(otherLocation.myPosition);
    }

    public String toString() {
        return this.myPosition.toString();
    }
}

